<?php

namespace App\Http\Controllers\Admin;

use App\Constants\PaymentGatewayConst;
use App\Http\Controllers\Controller;
use App\Http\Helpers\Response;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class VirtualCardLogController extends Controller
{
    /**
     * Method for virtual card logs
     */
    public function index(){
        $page_title     = "All Virtual Card Logs";
        $transactions   = Transaction::where('type',[PaymentGatewayConst::VIRTUALCARD,PaymentGatewayConst::CARDBUY,PaymentGatewayConst::CARDFUND,PaymentGatewayConst::CARDWITHDRAW])->orderBy('id','desc')->get();
        return view('admin.sections.virtual-card-logs.index',compact(
            'page_title',
            'transactions'
        ));
    }

    /**
     * Method for virtual card log details page
     * @param $id
     */
    public function details($id){
        $page_title         = "Virtual Card Log Details";
        $transaction        = Transaction::with(['user','user_wallets'])->where('id',$id)->first();
        // $transaction_device = TransactionDevice::where('transaction_id',$id)->first();

        if(!$transaction) return back()->with(['error' => ['Data not found']]);

        return view('admin.sections.virtual-card-logs.details',compact(
            'page_title',
            'transaction'
        ));

    }
    /**
    * Method for search buy crypto log
    */
    public function search(Request $request) {
        $validator = Validator::make($request->all(),[
            'text'  => 'required|string',
        ]);
        if($validator->fails()) {
            $error = ['error' => $validator->errors()];
            return Response::error($error,null,400);
        }

        $validated = $validator->validate();

        $transactions    = Transaction::auth()->where('type',[PaymentGatewayConst::VIRTUALCARD,PaymentGatewayConst::CARDBUY,PaymentGatewayConst::CARDFUND,PaymentGatewayConst::CARDWITHDRAW])
                                    ->search($validated['text'])->get();

        return view('admin.components.search.virtual-card-log-search',compact('transactions'));

    }
}
