<?php

namespace App\Http\Controllers;

use App\Constants\PaymentGatewayConst;
use App\Http\Helpers\TransactionLimit;
use App\Models\Admin\Currency;
use Illuminate\Http\Request;
use App\Models\Admin\Language;
use App\Models\Admin\PaymentGatewayCurrency;
use App\Models\Admin\TransactionSetting;
use App\Models\VirtualCardApi;
use Illuminate\Support\Facades\Session;

class GlobalController extends Controller
{

    /**
     * Funtion for get state under a country
     * @param country_id
     * @return json $state list
     */
    public function getStates(Request $request) {
        $request->validate([
            'country_id' => 'required|integer',
        ]);
        $country_id = $request->country_id;
        // Get All States From Country
        $country_states = get_country_states($country_id);
        return response()->json($country_states,200);
    }
    /**
     * Method for get cities
     */
    public function getCities(Request $request) {
        $request->validate([
            'state_id' => 'required|integer',
        ]);

        $state_id = $request->state_id;
        $state_cities = get_state_cities($state_id);

        return response()->json($state_cities,200);

    }
    /**
     * Method for get countries
     */
    public function getCountries(Request $request) {
        $countries = get_all_countries();

        return response()->json($countries,200);
    }
    /**
     * Method for get time zones
     */
    public function getTimezones(Request $request) {
        $timeZones = get_all_timezones();

        return response()->json($timeZones,200);
    }
    /**
     * Method for language swithch
     */
    public function languageSwitch(Request $request) {
        $code = $request->target;
        $language = Language::where("code",$code)->first();
        if(!$language) {
            return back()->with(['error' => ['Oops! Language Not Found!']]);
        }
        Session::put('local',$code);
        Session::put('local_dir',$language->dir);

        return back()->with(['success' => ['Language Switch to ' . $language->name ]]);
    }

    // public function getTotalTransactions(Request $request){
    //     $user_field         = $request->user_field;
    //     $user_id            = $request->user_id;
    //     $transaction_type   = $request->transaction_type;
    //     $wallet_currency    = $request->wallet_currency;
    //     $card_currency      = $request->card_currency;
    //     $sender_amount      = $request->sender_amount;
    //     $charge_id          = $request->charge_id;
    //     $attribute          = $request->attribute;
    //     $extra_rate         = $request->rate;


    //     $currency = Currency::where('code',$wallet_currency)->active()->first();

    //     if($transaction_type == PaymentGatewayConst::WITHDRAWMONEY || $transaction_type == PaymentGatewayConst::TYPEADDMONEY){
    //         $limits = PaymentGatewayCurrency::where('id',$charge_id)->first();
    //     }else{
    //         if( $transaction_type == payment_gateway_const()::VIRTUALCARD && activeCardSystem() == 'cardyfie'){
    //             $cardApi = VirtualCardApi::where('provider_slug',activeCardSystem())->first();
    //             $card_currency = $cardApi->currencies->where('currency_code',$card_currency)->first();
    //             $limits = (object)[
    //                 'id'            => 1,
    //                 'daily_limit'   => floatval($card_currency->daily_limit ?? 0),
    //                 'monthly_limit' => floatval($card_currency->monthly_limit ?? 0),
    //             ];
    //         }else{
    //             $limits = TransactionSetting::where('id',$charge_id)->first();
    //         }

    //     }
    //     // dd($limits);

    //     $result = (new TransactionLimit())->trxLimit($user_field,$user_id,$transaction_type,$currency,$sender_amount,$limits,$attribute,'json',$extra_rate);
    //     // dd($result);

    //     return response()->json($result);

    // }
}
