<?php

namespace App\Http\Helpers;

use Exception;
use Carbon\Carbon;
use App\Models\Transaction;
use App\Constants\PaymentGatewayConst;

class TransactionLimit{
    public function getExchangeRate($fromCurrency)
    {
        $base_currency_rate     = get_default_currency_rate();
        $from_currency_rate     = $fromCurrency->rate ?? 1;
        $exchange_rate          = $from_currency_rate / $base_currency_rate;

        return $exchange_rate;
    }
    function trxLimit($user_field,$userId,$transactionType,$currency,$amount,$limits,$attribute,$json = null,$extra_rate = 1){
        $transactionDate = now();
        //  Get the limits for the specified transaction type
        if($transactionType == PaymentGatewayConst::WITHDRAWMONEY || $transactionType == PaymentGatewayConst::TYPEADDMONEY){


            $exchange_rate =  $limits->rate/$currency->rate;

            $dailyLimitBaseCurrency     = $limits->daily_limit / $exchange_rate ;  // in Base Currency
            $monthlyLimitBaseCurrency   = $limits->monthly_limit / $exchange_rate ; // in Base Currency

            //make convert to base curr
            $reverse_exchange_rate_base = ( get_default_currency_rate() / $currency->rate);

            $dailyLimitBaseCurrency     = ( $dailyLimitBaseCurrency *  $reverse_exchange_rate_base);   // in Selected Currency
            $monthlyLimitBaseCurrency   = ($monthlyLimitBaseCurrency *  $reverse_exchange_rate_base);  // in Selected Currency

            $dailyLimitSelectedCurrency     = ( $limits->daily_limit / $exchange_rate);  // in Selected Currency
            $monthlyLimitSelectedCurrency   = ($limits->monthly_limit / $exchange_rate); // in Selected Currency


        }elseif($transactionType == PaymentGatewayConst::VIRTUALCARD){
            if (!is_numeric($extra_rate) || is_nan((float) $extra_rate)) {
                $extra_rate = 1;
            }

            $dailyLimitBaseCurrency     = $limits->daily_limit;  // in Base Currency
            $monthlyLimitBaseCurrency   = $limits->monthly_limit; // in Base Currency


            $dailyLimitSelectedCurrency     = ($dailyLimitBaseCurrency);  // in Selected Currency
            $monthlyLimitSelectedCurrency   = ($monthlyLimitBaseCurrency); // in Selected Currency

            // return [$dailyLimitSelectedCurrency,$monthlyLimitSelectedCurrency];

        }else{
            $dailyLimitBaseCurrency     = $limits->daily_limit;  // in Base Currency
            $monthlyLimitBaseCurrency   = $limits->monthly_limit ; // in Base Currency

            $dailyLimitSelectedCurrency     = ($dailyLimitBaseCurrency * $currency->rate);  // in Selected Currency
            $monthlyLimitSelectedCurrency   = ($monthlyLimitBaseCurrency * $currency->rate); // in Selected Currency
        }


        $exchangeRate = $this->getExchangeRate($currency); // This function should return the conversion rate for currency to Base Currency

        // return [$exchangeRate];

        if (!$exchangeRate) {
            throw new Exception(json_encode([
                'status' => false,
                'message' => 'Exchange rate not found',
                'user_field' => $user_field,
                'user_id' => $userId,
                'transaction_type' => $transactionType
            ]));
        }


        // Convert the transaction amount to the base currency (Base Currency)
        $amountInBasedCurrency = $amount / $exchangeRate;


        $dailyTotals = Transaction::where($user_field, $userId)
                            ->where('type', $transactionType)
                            ->where('attribute',$attribute)
                            ->where('status',PaymentGatewayConst::STATUSSUCCESS)
                            ->whereDate('created_at', Carbon::parse($transactionDate)->toDateString())
                            ->get();


        $monthlyTotals= Transaction::where($user_field, $userId)
                            ->where('type', $transactionType)
                            ->where('attribute',$attribute)
                            ->where('status',PaymentGatewayConst::STATUSSUCCESS)
                            ->whereYear('created_at', Carbon::parse($transactionDate)->year)
                            ->whereMonth('created_at', Carbon::parse($transactionDate)->month)
                            ->get();

        // return [$dailyTotals,$monthlyTotals];

        // Calculate the daily & monthly total for the transaction type in the base currency (Base Currency)
        $dailyTotalInBasedCurrency      = ($this->getTransactionOnBaseCurrency($dailyTotals));
        $monthlyTotalInBasedCurrency    = ($this->getTransactionOnBaseCurrency($monthlyTotals));

         // Calculate the daily & monthly total for the transaction type in the selected currency (Selected Currency)
        $totalInCurrencyDaily = ($dailyTotalInBasedCurrency * $currency->rate);
        $totalInCurrencyMonthly = ($monthlyTotalInBasedCurrency * $currency->rate);



         // Calculate the remaining  daily & monthly total for the transaction type in the selected currency (Selected Currency)
        $totalRemainingDaily = ($dailyLimitSelectedCurrency - $totalInCurrencyDaily);
        $totalRemainingMonthly = ($monthlyLimitSelectedCurrency - $totalInCurrencyMonthly);

        $totalRemainingDaily  = $totalRemainingDaily <= 0 ? 0 :$totalRemainingDaily;
        $totalRemainingMonthly  = $totalRemainingMonthly <= 0 ? 0 :$totalRemainingMonthly;

        $data =[
            'totalDailyTxnBase'             => get_amount($dailyTotalInBasedCurrency,null,get_wallet_precision($currency)) ?? 0,
            'totalMonthlyTxnBase'           => get_amount($monthlyTotalInBasedCurrency,null,get_wallet_precision($currency)) ?? 0,

            'totalDailyTxnSelected'         => get_amount($totalInCurrencyDaily,null,get_wallet_precision($currency)) ?? 0,
            'totalMonthlyTxnSelected'       => get_amount($totalInCurrencyMonthly,null,get_wallet_precision($currency)) ?? 0,

            'remainingDailyTxnSelected'     => get_amount($totalRemainingDaily,null,get_wallet_precision($currency)) ?? 0,
            'remainingMonthlyTxnSelected'   => get_amount($totalRemainingMonthly,null,get_wallet_precision($currency)) ?? 0


        ];

        // Validate daily and monthly limits
        if ($dailyLimitBaseCurrency > 0 && ($dailyTotalInBasedCurrency + $amountInBasedCurrency) > $dailyLimitBaseCurrency) {

            if($json != null){
                return[
                    'status'            => false,
                    'message'           => __('Daily transaction limit exceeded.'),
                    'user_field'        => $user_field,
                    'user_id'           => $userId,
                    'transaction_type'  => $transactionType,
                    'data'              => $data,
                ];

            }else{

                throw new Exception(json_encode([
                    'status'            => false,
                    'message'           => __('Daily transaction limit exceeded.'),
                    'user_field'        => $user_field,
                    'user_id'           => $userId,
                    'transaction_type'  => $transactionType,
                    'data'              =>  $data,
                ]));
            }

        }

        if ($monthlyLimitBaseCurrency > 0 && ($monthlyTotalInBasedCurrency + $amountInBasedCurrency) > $monthlyLimitBaseCurrency) {
            if($json != null){
                return[
                    'status'            => false,
                    'message'           => __('Monthly transaction limit exceeded.'),
                    'user_field'        => $user_field,
                    'user_id'           => $userId,
                    'transaction_type'  => $transactionType,
                    'data'              => $data,
                ];

            }else{
                throw new Exception(json_encode([
                    'status'                => false,
                    'message'               => __('Monthly transaction limit exceeded.'),
                    'user_field'            => $user_field,
                    'user_id'               => $userId,
                    'transaction_type'      => $transactionType,
                    'data'                  => $data,
                ]));
            }

        }


        return [
            'status'                => true,
            'message'               => __('Your current total transaction amount'),
            'user_field'            => $user_field,
            'user_id'               => $userId,
            'transaction_type'      => $transactionType,
            'data'                  => $data,

        ];
    }

    public function getTransactionOnBaseCurrency($transactions){
        $totalAmount = 0;
        foreach ($transactions as $transaction) {
            $requestAmount = $transaction->amount;
            if($transaction->type == PaymentGatewayConst::VIRTUALCARD){
                $exchange_rate = 1;
            }else{
                $exchange_rate = $transaction->creator_wallet->currency->rate??get_default_currency_rate();
            }
            $result = $requestAmount / $exchange_rate;
            $totalAmount += $result;
        }
        return $totalAmount??0 ;

    }
}
