<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SetupPage extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    protected $casts = [
        'title'         => 'string',
        'details'       => 'object',
        'menu_active'   => 'object',
        'block_routes'   => 'object',
    ];

    public function sections(){
        return $this->hasMany(SetupPageHasSection::class,'setup_page_id')->orderBy('position', 'asc');
    }
}
