<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VirtualCardApi extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    protected $casts = [
        'admin_id' => 'integer',
        'provider_title' => 'string',
        'provider_image' => 'string',
        'provider_image' => 'string',
        'supported_currencies' => 'object',
        'config' => 'object',
        'card_details' => 'string',
        'card_limit' => 'integer',
        'status' => 'integer',
    ];


    public function currencies(){
        return $this->hasMany(VirtualCardProviderCurrency::class,'provider_id','id');
    }
}
