<?php
namespace App\Traits\PaymentGateway;

use App\Models\TemporaryData;
use App\Constants\PaymentGatewayConst;

trait Authorize{

    public function authorizeInit($output = null){
        if(!$output) $output = $this->output;
        return $this->setupAuthorizeInit($output);
    }

    public function setupAuthorizeInit($output){
        $junk_data = $this->authorizeJunkInsert();
        if(request()->expectsJson()) {
            $data = [
                'redirect_url'      => route('api.user.buy.crypto.authorize.payment'),
                'redirect_links'    => [],
                'type'              => PaymentGatewayConst::BUY_CRYPTO,
                'address_info'      => [],
                'identifier'        => $junk_data->identifier,
            ];

            return $data;
        }
        return redirect()->route('user.buy.crypto.authorize.card.info',$junk_data->identifier);
    }
    public function authorizeJunkInsert() {
        $output = $this->output;
        $temp_record_token = generate_unique_string('temporary_datas', 'identifier', 60);

        $data = [
            'gateway'       => $output['gateway']->id,
            'currency'      => $output['currency']->id,
            'payment_method'=> $output['currency'],
            'amount'        => json_decode(json_encode($output['amount']),true),
            'wallet_table'  => $output['wallet']->getTable(),
            'wallet'        => [
                'wallet_id' => $output['wallet']->id,
            ],
            'creator_table' => auth()->guard(get_auth_guard())->user()->getTable(),
            'creator_id'    => auth()->guard(get_auth_guard())->user()->id,
            'creator_guard' => get_auth_guard(),
            'user_record'   => $output['form_data']['identifier'],
        ];

        return TemporaryData::create([
            'type'          => PaymentGatewayConst::BUY_CRYPTO,
            'identifier'    => $temp_record_token,
            'data'          => $data,
        ]);
    }
    public function authorizeInitApi($output = null){
        if(!$output) $output = $this->output;
        return $this->setupAuthorizeInit($output);
    }
}

?>
