<?php

namespace App\View\Components\Security;

use Closure;
use Illuminate\View\Component;
use App\Constants\ExtensionConst;
use Illuminate\Contracts\View\View;
use App\Providers\Admin\ExtensionProvider;

class GoogleRecaptchaField extends Component
{
    public string $site_key;

    public $extension;
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        $extension = ExtensionProvider::get()->where('slug', ExtensionConst::GOOGLE_RECAPTCHA_SLUG)->first();
        $site_key = $extension->shortcode->site_key->value ?? '';

        $this->site_key = $site_key;
        $this->extension = $extension;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.security.google-recaptcha-field');
    }
}
