<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('support_tickets',function(Blueprint $table){
            $table->unsignedBigInteger('admin_id')->after('user_id')->nullable();
            $table->string('name')->nullable()->change();
            $table->string('email')->nullable()->change();

            $table->foreign('admin_id')->references('id')->on('admins')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('support_tickets',function(Blueprint $table){
            $table->dropForeign(['admin_id']);
            $table->dropColumn('admin_id');
            $table->string('name')->nullable(false)->change();
            $table->string('email')->nullable(false)->change();
        });
    }
};
