<?php

use App\Constants\PaymentGatewayConst;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->string('type')->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->enum('type', [
                PaymentGatewayConst::BUY_CRYPTO,
                PaymentGatewayConst::SELL_CRYPTO,
                PaymentGatewayConst::WITHDRAW_CRYPTO,
                PaymentGatewayConst::EXCHANGE_CRYPTO,
                PaymentGatewayConst::TYPEADDSUBTRACTBALANCE,
            ])->change();
        });
    }
};
