<?php

namespace Database\Seeders\Admin;

use App\Models\Admin\PaymentGateway;
use App\Models\Admin\PaymentGatewayCurrency;
use Illuminate\Database\Seeder;

class PaymentGatewaySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $payment_gateways = array(
            array('id' => '1' ,'slug' => 'payment-method','code' => '120','type' => 'AUTOMATIC','name' => 'CoinGate','title' => 'Crypto Payment gateway','alias' => 'coingate','image' => 'seeder/coin_gate.png','credentials' => '[{"label":"Sandbox URL","placeholder":"Enter Sandbox URL","name":"sandbox-url","value":"https:\\/\\/api-sandbox.coingate.com\\/v2"},{"label":"Sandbox App Token","placeholder":"Enter Sandbox App Token","name":"sandbox-app-token","value":"XJW4RyhT8F-xssX2PvaHMWJjYe5nsbsrbb2Uqy4m"},{"label":"Production URL","placeholder":"Enter Production URL","name":"production-url","value":"https:\\/\\/api.coingate.com\\/v2"},{"label":"Production App Token","placeholder":"Enter Production App Token","name":"production-app-token","value":null}]','supported_currencies' => '["USD","BTC","LTC","ETH","BCH","TRX","ETC","DOGE","BTG","BNB","TUSD","USDT","BSV","MATIC","BUSD","SOL","WBTC","RVN","BCD","ATOM","BTTC","EURT"]','crypto' => '1','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-08-07 10:36:30','updated_at' => '2023-08-07 12:06:12'),

            array('id' => '2' ,'slug' => 'payment-method','code' => '215','type' => 'AUTOMATIC','name' => 'Tatum','title' => 'Tatum Gateway','alias' => 'tatum','image' => 'seeder/tatum.jpg','credentials' => '[{"label":"Testnet","placeholder":"Enter Testnet","name":"test-net","value":"t-6582a4f67a5ea0001c55dab5-80ad272cb3324f9ba3a67ec3"},{"label":"Mainnet","placeholder":"Enter Mainnet","name":"main-net","value":"t-6582a4f67a5ea0001c55dab5-eed952f5e418465ea41aeedf"}]','supported_currencies' => '["BTC","ETH","SOL"]','crypto' => '1','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-11-07 17:05:37','updated_at' => '2023-11-07 17:44:00'),

            array('id' => '3' ,'slug' => 'payment-method','code' => '105','type' => 'AUTOMATIC','name' => 'Paypal','title' => 'Paypal Gateway','alias' => 'paypal','image' => 'seeder/paypal.webp','credentials' => '[{"label":"Client ID","placeholder":"Enter Client ID","name":"client-id","value":"AbMgZu03hDEAs8aMK96dj52nCFfEEFd2nSffXsdf8NIBbOiogClRVFbsFqxqPjQHeb221XXCrZR2GXyZ"},{"label":"Secret ID","placeholder":"Enter Secret ID","name":"secret-id","value":"EHjAeQn76vtKvJBUipJ54BFqUrcuP4bB01xgbAGAn7q-p5WgtGzj6FFeEzXuTNEVaPtCcP4qKSwQu0sb"}]','supported_currencies' => '["USD","GBP","PHP","NZD","MYR","EUR","CNY","CAD","AUD"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-05-29 11:09:41','updated_at' => '2023-11-30 08:42:48'),

            array('id' => '4' ,'slug' => 'payment-method','code' => '125','type' => 'AUTOMATIC','name' => 'Stripe','title' => 'Stripe Gateway','alias' => 'stripe','image' => 'seeder/stripe.webp','credentials' => '[{"label":"Test Publishable Key","placeholder":"Enter Test Publishable Key","name":"test-publishable-key","value":"pk_test_51NECrlJXLo7QTdMco2E4YxHSeoBnDvKmmi0CZl3hxjGgH1JwgcLVUF3ZR0yFraoRgT7hf0LtOReFADhShAZqTNuB003PnBSlGP"},{"label":"Test Secret Key","placeholder":"Enter Test Secret Key","name":"test-secret-key","value":"sk_test_51NECrlJXLo7QTdMc2x7K5LaDuiS0MGNYHkO9dzzV0Y9XuWNZsXjECFsusjZEnqtxMIjCh3qtogc5sHHwL2oQ083900aFy1k7DE"},{"label":"Live Publishable Key","placeholder":"Enter Live Publishable Key","name":"live-publishable-key","value":null},{"label":"Live Secret Key","placeholder":"Enter Live Secret Key","name":"live-secret-key","value":null}]','supported_currencies' => '["USD","GBP","PHP","NZD","MYR","EUR","CNY","CAD","AUD","NGN"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-11-30 08:42:28','updated_at' => '2023-11-30 08:43:57'),

            array('id' => '5' ,'slug' => 'payment-method','code' => '130','type' => 'AUTOMATIC','name' => 'Flutterwave','title' => 'Flutterwave Gateway','alias' => 'flutterwave','image' => 'seeder/flutterwave.webp','credentials' => '[{"label":"Encryption key","placeholder":"Enter Encryption key","name":"encryption-key","value":"FLWSECK_TEST27bee2235efd"},{"label":"Secret key","placeholder":"Enter Secret key","name":"secret-key","value":"FLWSECK_TEST-da35e3dbd28be1e7dc5d5f3519e2ebef-X"}]','supported_currencies' => '["USD","GBP","PHP","NZD","MYR","EUR","CNY","CAD","AUD","NGN"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-11-30 08:49:31','updated_at' => '2023-11-30 08:51:26'),

            array('id' => '6','slug' => 'payment-method','code' => '210','type' => 'AUTOMATIC','name' => 'SSLCommerz','title' => 'SSLCommerz Payment Gateway For Sell Crypto','alias' => 'sslcommerz','image' => 'seeder/sslcommerz.webp','credentials' => '[{"label":"Store Id","placeholder":"Enter Store Id","name":"store-id","value":"appde6513b3970d62c"},{"label":"Store Password","placeholder":"Enter Store Password","name":"store-password","value":"appde6513b3970d62c@ssl"},{"label":"Sandbox Url","placeholder":"Enter Sandbox Url","name":"sandbox-url","value":"https:\\/\\/sandbox.sslcommerz.com"},{"label":"Live Url","placeholder":"Enter Live Url","name":"live-url","value":"https:\\/\\/securepay.sslcommerz.com"}]','supported_currencies' => '["BDT","EUR","GBP","AUD","USD","CAD"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'status' => '1','last_edit_by' => '1','created_at' => '2023-09-27 16:11:26','updated_at' => '2023-09-27 16:11:53','env' => 'SANDBOX'),
            
            array('id' => '7','slug' => 'payment-method','code' => '10025','type' => 'AUTOMATIC','name' => 'Razorpay','title' => 'Razorpay Gateway','alias' => 'razorpay','image' => 'seeder/razor-pay.webp','credentials' => '[{"label":"Key ID","placeholder":"Enter Key ID","name":"key-id","value":"rzp_test_voV4gKUbSxoQez"},{"label":"Secret Key","placeholder":"Enter Secret Key","name":"secret-key","value":"cJltc1jy6evA4Vvh9lTO7SWr"}]','supported_currencies' => '["USD","EUR","GBP","SGD","AED","AUD","CAD","CNY","SEK","NZD","MXN","BDT","EGP","HKD","INR","LBP","LKR","MAD","MYR","NGN","NPR","PHP","PKR","QAR","SAR","UZS","GHS"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-11-09 17:26:21','updated_at' => '2023-11-09 17:36:05'),

            array('id' => '8','slug' => 'payment-method','code' => '245','type' => 'AUTOMATIC','name' => 'Pagadito','title' => 'Pagadito Payment gateway','alias' => 'pagadito','image' => 'seeder/pagadito.webp','credentials' => '[{"label":"UID","placeholder":"Enter UID","name":"uid","value":"b73eb3fa1dc8bea4b4363322c906a8fd"},{"label":"WSK","placeholder":"Enter WSK","name":"wsk","value":"dc843ff5865bac2858ad8f23af081256"},{"label":"base_url","placeholder":"Enter base_url","name":"base_url","value":"https:\\/\\/sandbox.pagadito.com"}]','supported_currencies' => '["USD","HNL","CRC","DOP","GTQ","NIO","PAB"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2024-01-08 04:05:40','updated_at' => '2024-01-08 04:05:40'),

            array('id' => '9' ,'slug' => 'payment-method','code' => '160','type' => 'MANUAL','name' => 'JazzCash','title' => 'JazzCash Gateway','alias' => 'jazzcash','image' => NULL,'credentials' => NULL,'supported_currencies' => '["PKR"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => NULL),
           
            array('id' => '10','slug' => 'money-out','code' => '220','type' => 'MANUAL','name' => 'ADOut','title' => 'ADOut Gateway','alias' => 'adout','image' => NULL,'credentials' => NULL,'supported_currencies' => '["USD"]','crypto' => '0','desc' => '<p>A network refers to a system of interconnected elements or entities that communicate and interact with each other. In the realm of technology, a network commonly denotes the interconnection of computers, devices, or systems to facilitate the exchange of information and resources.</p>','input_fields' => '[{"type":"text","label":"Branch","name":"branch","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"text","label":"Bank Number","name":"bank_number","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"text","label":"Bank Name","name":"bank_name","required":true,"validation":{"max":"300","mimes":[],"min":"0","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => '2024-01-02 10:44:05'),
                
            array('id' => '11','slug' => 'money-out','code' => '225','type' => 'MANUAL','name' => 'ADFund','title' => 'ADFund Gateway','alias' => 'adfund','image' => NULL,'credentials' => NULL,'supported_currencies' => '["USD"]','crypto' => '0','desc' => '<p>A network refers to a system of interconnected elements or entities that communicate and interact with each other. In the realm of technology, a network commonly denotes the interconnection of computers, devices, or systems to facilitate the exchange of information and resources.</p>','input_fields' => '[{"type":"text","label":"Branch","name":"branch","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"text","label":"Bank Number","name":"bank_number","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"text","label":"Bank Name","name":"bank_name","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => '2024-01-02 10:43:06'),
            
            array('id' => '5000','slug' => 'payment-method','code' => '20005','type' => 'AUTOMATIC','name' => 'Perfect Money','title' => 'Perfect Money Gateway','alias' => 'perfect-money','image' => 'seeder/perfect-money.webp','credentials' => '[{"label":"USD Account","placeholder":"Enter USD Account","name":"usd-account","value":""},{"label":"EUR Account","placeholder":"Enter EUR Account","name":"eur-account","value":""},{"label":"Alternate Passphrase","placeholder":"Enter Alternate Passphrase","name":"alternate_passphrase","value":""}]','supported_currencies' => '["USD","EUR"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-12-30 16:05:59','updated_at' => '2024-01-03 06:22:22'),

            array('id' => '10000','slug' => 'payment-method','code' => '30005','type' => 'AUTOMATIC','name' => 'Paystack','title' => 'Paystack Gateway','alias' => 'paystack','image' => 'seeder/paystack.webp','credentials' => '[{"label":"Secret Key","placeholder":"Enter Secret Key","name":"secret-key","value":"sk_test_877d3ad96e1ee36a20d6736a8d358a999dad42c0"},{"label":"Email","placeholder":"Enter Email","name":"email","value":"akash@appdevs.team"}]','supported_currencies' => '["USD","GBP","PHP","NZD","MYR","EUR","CNY","CAD","AUD","NGN","GHS"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2024-08-08 04:26:27','updated_at' => '2024-08-08 04:27:36'),
        
            array('id' => '20000','slug' => 'payment-method','code' => '40005','type' => 'AUTOMATIC','name' => 'Authorize','title' => 'Authorize Payment Gateway','alias' => 'authorize','image' => 'seeder/authorize-net.webp','credentials' => '[{"label":"App Login ID","placeholder":"Enter App Login ID","name":"app-login-id","value":"5wEnX48K4W85"},{"label":"Transaction Key","placeholder":"Enter Transaction Key","name":"transaction-key","value":"8Gf4uq9Nb55y7Yzg"},{"label":"Signature Key","placeholder":"Enter Signature Key","name":"signature-key","value":"B17BB1A22564FD12838A05884B51BE09EA7A98AD61E81BF6BD8BBD69414CE047D30FCBACE679AD76807670D3D261F920D80527332879790B7B4432642EA390D6"}]','supported_currencies' => '["USD"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'status' => '1','last_edit_by' => '1','created_at' => '2025-03-23 23:40:36','updated_at' => '2025-03-23 23:41:45','env' => 'SANDBOX'),

            array('id' => '20001','slug' => 'payment-method','code' => '40010','type' => 'AUTOMATIC','name' => 'Tap Payment','title' => 'Tap Payment Gateway','alias' => 'tap-payment','image' => 'seeder/tap-payment.webp','credentials' => '[{"label":"Base URL","placeholder":"Enter Base URL","name":"base-url","value":"https:\\/\\/api.tap.company\\/v2\\/charges\\/"},{"label":"Secret Key","placeholder":"Enter Secret Key","name":"secret-key","value":"sk_test_XKokBfNWv6FIYuTMg5sLPjhJ"}]','supported_currencies' => '["USD"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2025-08-11 05:11:29','updated_at' => '2025-08-11 05:12:18'),
        );

        PaymentGateway::upsert($payment_gateways,['code'],[]);

        $payment_gateway_currencies = array(
            array('payment_gateway_id' => '1','name' => 'CoinGate USDT','alias' => 'payment-method-coingate-usdt-automatic','currency_code' => 'USDT','currency_symbol' => '$','image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '3.00000000','fixed_charge' => '2.00000000','rate' => '43009','created_at' => '2023-08-07 12:06:12','updated_at' => '2023-08-07 12:36:10'),
            
            array('payment_gateway_id' => '2','name' => 'Tatum ETH','alias' => 'payment-method-tatum-eth-automatic','currency_code' => 'ETH','currency_symbol' => 'ETH','image' => NULL,'min_limit' => '1','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '18.91','created_at' => '2023-11-07 17:10:38','updated_at' => '2023-11-07 17:44:00'),
            
            array('payment_gateway_id' => '3','name' => 'Paypal USD','alias' => 'payment-method-paypal-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => 'seeder/paypal.webp','min_limit' => '1','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '37675.20000000','created_at' => '2023-11-30 07:22:48','updated_at' => '2023-11-30 08:42:48'),
            
            array('payment_gateway_id' => '4','name' => 'Stripe AUD','alias' => 'payment-method-stripe-aud-automatic','currency_code' => 'AUD','currency_symbol' => 'A$','image' => 'seeder/stripe.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '56845.10000000','created_at' => '2023-11-30 08:43:57','updated_at' => '2023-11-30 08:43:57'),
            
            array('payment_gateway_id' => '5','name' => 'Flutterwave NGN','alias' => 'payment-method-flutterwave-ngn-automatic','currency_code' => 'NGN','currency_symbol' => '₦','image' => 'seeder/flutterwave.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '29778649.15000000','created_at' => '2023-11-30 08:51:26','updated_at' => '2023-11-30 08:51:26'),

            array('payment_gateway_id' => '6','name' => 'SSLCommerz BDT','alias' => 'payment-method-sslcommerz-bdt-automatic','currency_code' => 'BDT','currency_symbol' => '৳','image' => NULL,'min_limit' => '100.00000000','max_limit' => '50000.00000000','percent_charge' => '0.00000000','fixed_charge' => '1.00000000','rate' => '5032884.55','created_at' => '2023-09-27 16:11:53','updated_at' => '2023-09-27 16:12:04'),

            array('payment_gateway_id' => '7','name' => 'Razorpay USD','alias' => 'payment-method-razorpay-usd-automatic','currency_code' => 'USD','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '37675.20000000','created_at' => '2023-11-09 17:36:05','updated_at' => '2023-11-09 17:36:05'),
            
            array('payment_gateway_id' => '8','name' => 'Pagadito USD','alias' => 'payment-method-pagadito-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => 'seeder/pagadito.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '37675.20000000','created_at' => '2024-01-08 04:11:48','updated_at' => '2024-01-08 04:12:21'),

            array('payment_gateway_id' => '9','name' => 'JazzCash PKR','alias' => 'payment-method-jazzcash-pkr-manual','currency_code' => 'PKR','currency_symbol' => 'Rs','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '289.38000000','created_at' => '2023-08-14 18:13:11','updated_at' => '2023-08-14 18:13:11'),
        
            array('payment_gateway_id' => '10','name' => 'ADOut USD','alias' => 'money-out-adout-usd-manual','currency_code' => 'USD','currency_symbol' => '$','image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '45218.00000000','created_at' => '2024-01-02 05:02:39','updated_at' => '2024-01-02 10:15:33'),
            
            array('payment_gateway_id' => '11','name' => 'ADFund USD','alias' => 'money-out-adfund-usd-manual','currency_code' => 'USD','currency_symbol' => '$','image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '2.00000000','rate' => '45218.00000000','created_at' => '2024-01-02 10:02:31','updated_at' => '2024-01-02 10:02:31'),
            
            array('payment_gateway_id' => '5000','name' => 'Perfect Money USD','alias' => 'payment-method-perfect-money-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => NULL,'min_limit' => '1.00000000','max_limit' => '5000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '37675.20000000','created_at' => '2023-12-30 16:44:49','updated_at' => '2023-12-30 16:44:49'),
        
            array('payment_gateway_id' => '10000','name' => 'Paystack NGN','alias' => 'payment-method-paystack-ngn-automatic','currency_code' => 'NGN','currency_symbol' => '₦','image' => 'seeder/paystack.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '29778649.15000000','created_at' => '2024-08-08 04:27:36','updated_at' => '2024-08-08 05:05:31'),

            array('payment_gateway_id' => '20000','name' => 'Authorize USD','alias' => 'payment-method-authorize-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => 'seeder/authorize-net.webp','min_limit' => '1.00000000','max_limit' => '50.00000000','percent_charge' => '3.50000000','fixed_charge' => '0.00000000','rate' => '1.00000000','created_at' => '2025-03-23 23:41:46','updated_at' => '2025-03-23 23:41:46'),

            array('payment_gateway_id' => '20001','name' => 'Tap Payment Gateway USD','alias' => 'payment-method-tap-payment-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => 'seeder/tap-payment.webp','min_limit' => '1.00000000','max_limit' => '100000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2025-08-11 05:12:19','updated_at' => '2025-08-11 05:12:19'),
        );

        PaymentGatewayCurrency::upsert($payment_gateway_currencies,['alias'],[]);
    }
}
