<?php

namespace Database\Seeders\Admin;

use App\Models\Admin\SetupPage;
use App\Models\Admin\SetupPageHasSection;
use Illuminate\Database\Seeder;

class SetupPageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $setup_pages = array(
            array('slug' => 'home','title' => 'Home','url' => '/','menu_active' => json_encode(['index']),'block_routes' => json_encode(['index']),'route_name' => 'index','last_edit_by' => '1','status' => '1','default' => '1','created_at' => '2024-01-30 04:00:08','updated_at' => NULL),

            array('slug' => 'about','title' => 'About','url' => '/about','menu_active' => json_encode(['about']),'block_routes' => json_encode(['about']),'route_name' => 'about','last_edit_by' => '1','status' => '1','default' => '0','created_at' => '2024-01-30 04:00:08','updated_at' => NULL),

            array('slug' => 'service','title' => 'Service','url' => '/service','menu_active' => json_encode(['service']),'block_routes' => json_encode(['service']),'route_name' => 'service','last_edit_by' => '1','status' => '1','default' => '0','created_at' => '2024-01-30 04:00:08','updated_at' => NULL),

            array('slug' => 'web-journal','title' => 'Web Journal','url' => '/journal','menu_active' => json_encode(['journal','journal.details','journal.category','journals']),'block_routes' => json_encode(['journal','journal.details','journal.category','journals']),'route_name' => 'journal','last_edit_by' => '1','status' => '1','default' => '0','created_at' => '2024-01-30 04:00:08','updated_at' => NULL),

            array('slug' => 'contact','title' => 'Contact','url' => '/contact','menu_active' => json_encode(['contact']),'block_routes' => json_encode(['contact']),'route_name' => 'contact','last_edit_by' => '1','status' => '1','default' => '0','created_at' => '2024-01-30 04:00:08','updated_at' => NULL)
        );

        SetupPage::insert($setup_pages);

        $setup_page_has_sections = array(
            array('id' => '1','setup_page_id' => '1','site_section_id' => '3','position' => '1','status' => '1','created_at' => '2025-10-07 15:56:20','updated_at' => '2025-10-07 15:56:20'),
            array('id' => '2','setup_page_id' => '1','site_section_id' => '4','position' => '2','status' => '1','created_at' => '2025-10-07 15:56:20','updated_at' => '2025-10-07 15:56:20'),
            array('id' => '3','setup_page_id' => '1','site_section_id' => '14','position' => '3','status' => '1','created_at' => '2025-10-07 15:56:20','updated_at' => '2025-10-07 15:56:20'),
            array('id' => '4','setup_page_id' => '1','site_section_id' => '5','position' => '4','status' => '1','created_at' => '2025-10-07 15:56:20','updated_at' => '2025-10-07 15:56:20'),
            array('id' => '5','setup_page_id' => '1','site_section_id' => '6','position' => '5','status' => '1','created_at' => '2025-10-07 15:56:20','updated_at' => '2025-10-07 15:56:20'),
            array('id' => '6','setup_page_id' => '1','site_section_id' => '7','position' => '6','status' => '1','created_at' => '2025-10-07 15:56:20','updated_at' => '2025-10-07 15:56:20'),
            array('id' => '7','setup_page_id' => '2','site_section_id' => '10','position' => '1','status' => '1','created_at' => '2025-10-07 15:57:23','updated_at' => '2025-10-07 15:57:23'),
            array('id' => '8','setup_page_id' => '2','site_section_id' => '11','position' => '2','status' => '1','created_at' => '2025-10-07 15:57:23','updated_at' => '2025-10-07 15:57:23'),
            array('id' => '9','setup_page_id' => '3','site_section_id' => '12','position' => '1','status' => '1','created_at' => '2025-10-07 15:57:49','updated_at' => '2025-10-07 15:57:49')
        );

        SetupPageHasSection::insert($setup_page_has_sections);
    }
}
