<?php

namespace Database\Seeders\Admin;

use App\Models\Admin\UsefulLink;
use Illuminate\Database\Seeder;

class UsefulLinkSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $useful_links = array(
            array('type' => 'PRIVACY_POLICY','title' => '{"language":{"en":{"title":"Privacy Policy"},"es":{"title":"pol\\u00edtica de privacidad"},"ar":{"title":"\\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629"},"fr":{"title":"politique de confidentialit\\u00e9"},"hi":{"title":"\\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0928\\u0940\\u0924\\u093f"}}}','slug' => 'privacy-policy','url' => 'privacy-policy','content' => '{"language":{"en":{"content":"<h2><strong>Privacy Policy for AdCrypto<\\/strong><\\/h2><p>At AdCrypto, we understand the importance of privacy and are committed to protecting the personal information of our users. We believe in being transparent about our data collection and usage practices, and this privacy policy outlines what information we collect, how we use it, and who we share it with.<\\/p><h3><strong>Information Collection:<\\/strong><\\/h3><p>AdCrypto collects the following types of personal information from its users:<\\/p><ul><li>Name<\\/li><li>Phone Number<\\/li><li>Profile image<\\/li><\\/ul><p>The information is collected when the user creates an account with AdCrypto or updates their profile information. The profile image is optional, and the user has the choice of whether or not to upload it.<\\/p><h3><strong>Information Use:<\\/strong><\\/h3><p>AdCrypto uses the personal information collected from its users for the following purposes:<\\/p><ul><li>To provide a personalized experience for the user<\\/li><li>To send notifications and updates about the app<\\/li><li>To improve the app and its features based on user feedback and usage patterns<\\/li><li>To comply with legal obligations and to resolve disputes<\\/li><\\/ul><h3><strong>Information Sharing:<\\/strong><\\/h3><p>AdCrypto does not share any of the personal information collected from its users with third parties, except in the following cases:<\\/p><ul><li>When required by law<\\/li><li>To protect the rights and safety of AdCrypto and its users<\\/li><li>To enforce our terms of service<\\/li><\\/ul><h3><strong>Data Security:<\\/strong><\\/h3><p>AdCrypto takes the security of its users\' personal information seriously and has implemented appropriate technical and organizational measures to protect it. However, please note that no data transmission or storage can be guaranteed to be 100% secure.<\\/p><h3><strong>Contact Information:<\\/strong><\\/h3><p>If you have any questions or concerns regarding AdCrypto privacy policy or the information we collect, you can contact us at:<\\/p><ul><li>Email: support@AdCrypto.com<\\/li><\\/ul><h3><strong>Changes to Privacy Policy:<\\/strong><\\/h3><p>AdCrypto reserves the right to modify this privacy policy at any time. We will notify our users of any significant changes by posting a notice on our app or website and by updating the \\"Last Updated\\" date at the top of this policy. We encourage our users to regularly review this privacy policy to stay informed about how we are protecting their personal information.<\\/p>"},"es":{"content":"<p>Pol\\u00edtica de privacidad para AdCrypto<\\/p><p>En AdCrypto, entendemos la importancia de la privacidad y estamos comprometidos a proteger la informaci\\u00f3n personal de nuestros usuarios. Creemos en ser transparentes sobre nuestras pr\\u00e1cticas de recopilaci\\u00f3n y uso de datos, y esta pol\\u00edtica de privacidad describe qu\\u00e9 informaci\\u00f3n recopilamos, c\\u00f3mo la usamos y con qui\\u00e9n la compartimos.<\\/p><p>Recopilaci\\u00f3n de informaci\\u00f3n:<\\/p><p>AdCrypto recopila los siguientes tipos de informaci\\u00f3n personal de sus usuarios:<\\/p><p>Nombre<br>N\\u00famero de tel\\u00e9fono<br>Imagen de perfil<\\/p><p>La informaci\\u00f3n se recopila cuando el usuario crea una cuenta con AdCrypto o actualiza la informaci\\u00f3n de su perfil. La imagen de perfil es opcional y el usuario tiene la opci\\u00f3n de cargarla o no.<\\/p><p>Uso de la informaci\\u00f3n:<\\/p><p>AdCrypto utiliza la informaci\\u00f3n personal recopilada de sus usuarios para los siguientes fines:<\\/p><p>Proporcionar una experiencia personalizada al usuario.<br>Para enviar notificaciones y actualizaciones sobre la aplicaci\\u00f3n<br>Mejorar la aplicaci\\u00f3n y sus funciones en funci\\u00f3n de los comentarios de los usuarios y los patrones de uso.<br>Para cumplir con obligaciones legales y resolver disputas<\\/p><p>El intercambio de informaci\\u00f3n:<\\/p><p>AdCrypto no comparte ninguna informaci\\u00f3n personal recopilada de sus usuarios con terceros, excepto en los siguientes casos:<\\/p><p>Cuando lo exige la ley<br>Para proteger los derechos y la seguridad de AdCrypto y sus usuarios.<br>Para hacer cumplir nuestros t\\u00e9rminos de servicio<\\/p><p>Seguridad de datos:<\\/p><p>AdCrypto se toma en serio la seguridad de la informaci\\u00f3n personal de sus usuarios y ha implementado medidas t\\u00e9cnicas y organizativas apropiadas para protegerla. Sin embargo, tenga en cuenta que no se puede garantizar que ninguna transmisi\\u00f3n o almacenamiento de datos sea 100% seguro.<\\/p><p>Informaci\\u00f3n del contacto:<\\/p><p>Si tiene alguna pregunta o inquietud sobre la pol\\u00edtica de privacidad de AdCrypto o la informaci\\u00f3n que recopilamos, puede contactarnos en:<\\/p><p>Correo electr\\u00f3nico: support@AdCrypto.com<\\/p><p>Cambios a la Pol\\u00edtica de Privacidad:<\\/p><p>AdCrypto se reserva el derecho de modificar esta pol\\u00edtica de privacidad en cualquier momento. Notificaremos a nuestros usuarios sobre cualquier cambio significativo publicando un aviso en nuestra aplicaci\\u00f3n o sitio web y actualizando la fecha de \\"\\u00daltima actualizaci\\u00f3n\\" en la parte superior de esta pol\\u00edtica. Alentamos a nuestros usuarios a revisar peri\\u00f3dicamente esta pol\\u00edtica de privacidad para mantenerse informados sobre c\\u00f3mo protegemos su informaci\\u00f3n personal.<\\/p>"},"ar":{"content":"<p>\\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0644\\u0640 AdCrypto<\\/p><p>\\u0641\\u064a AdCrypto\\u060c \\u0646\\u062a\\u0641\\u0647\\u0645 \\u0623\\u0647\\u0645\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0648\\u0646\\u0644\\u062a\\u0632\\u0645 \\u0628\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629 \\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646\\u0627. \\u0646\\u062d\\u0646 \\u0646\\u0624\\u0645\\u0646 \\u0628\\u0623\\u0647\\u0645\\u064a\\u0629 \\u0627\\u0644\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629 \\u0641\\u064a\\u0645\\u0627 \\u064a\\u062a\\u0639\\u0644\\u0642 \\u0628\\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u062c\\u0645\\u0639 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0647\\u0627\\u060c \\u0648\\u062a\\u062d\\u062f\\u062f \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u0646\\u062c\\u0645\\u0639\\u0647\\u0627\\u060c \\u0648\\u0643\\u064a\\u0641 \\u0646\\u0633\\u062a\\u062e\\u062f\\u0645\\u0647\\u0627\\u060c \\u0648\\u0645\\u0639 \\u0645\\u0646 \\u0646\\u0634\\u0627\\u0631\\u0643\\u0647\\u0627.<\\/p><p>\\u062c\\u0645\\u0639 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a:<\\/p><p>\\u064a\\u0642\\u0648\\u0645 AdCrypto \\u0628\\u062c\\u0645\\u0639 \\u0627\\u0644\\u0623\\u0646\\u0648\\u0627\\u0639 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629 \\u0645\\u0646 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0647:<\\/p><p>\\u0627\\u0633\\u0645<br>\\u0631\\u0642\\u0645 \\u0627\\u0644\\u062a\\u0644\\u064a\\u0641\\u0648\\u0646<br>\\u0635\\u0648\\u0631\\u0629 \\u0627\\u0644\\u0645\\u0644\\u0641 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a<\\/p><p>\\u064a\\u062a\\u0645 \\u062c\\u0645\\u0639 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0639\\u0646\\u062f\\u0645\\u0627 \\u064a\\u0642\\u0648\\u0645 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0628\\u0625\\u0646\\u0634\\u0627\\u0621 \\u062d\\u0633\\u0627\\u0628 \\u0641\\u064a AdCrypto \\u0623\\u0648 \\u064a\\u0642\\u0648\\u0645 \\u0628\\u062a\\u062d\\u062f\\u064a\\u062b \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0645\\u0644\\u0641\\u0647 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a. \\u0635\\u0648\\u0631\\u0629 \\u0627\\u0644\\u0645\\u0644\\u0641 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a \\u0627\\u062e\\u062a\\u064a\\u0627\\u0631\\u064a\\u0629\\u060c \\u0648\\u0644\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u062d\\u0631\\u064a\\u0629 \\u0627\\u062e\\u062a\\u064a\\u0627\\u0631 \\u062a\\u062d\\u0645\\u064a\\u0644\\u0647\\u0627 \\u0623\\u0645 \\u0644\\u0627.<\\/p><p>\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a:<\\/p><p>\\u064a\\u0633\\u062a\\u062e\\u062f\\u0645 AdCrypto \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645 \\u062c\\u0645\\u0639\\u0647\\u0627 \\u0645\\u0646 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0647 \\u0644\\u0644\\u0623\\u063a\\u0631\\u0627\\u0636 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629:<\\/p><p>\\u0644\\u062a\\u0648\\u0641\\u064a\\u0631 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u0634\\u062e\\u0635\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645<br>\\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0625\\u0634\\u0639\\u0627\\u0631\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a\\u062b\\u0627\\u062a \\u062d\\u0648\\u0644 \\u0627\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642<br>\\u0644\\u062a\\u062d\\u0633\\u064a\\u0646 \\u0627\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642 \\u0648\\u0645\\u064a\\u0632\\u0627\\u062a\\u0647 \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u062a\\u0639\\u0644\\u064a\\u0642\\u0627\\u062a \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0648\\u0623\\u0646\\u0645\\u0627\\u0637 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645<br>\\u0644\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0648\\u062d\\u0644 \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a<\\/p><p>\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a:<\\/p><p>\\u0644\\u0627 \\u062a\\u0634\\u0627\\u0631\\u0643 AdCrypto \\u0623\\u064a\\u064b\\u0627 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645 \\u062c\\u0645\\u0639\\u0647\\u0627 \\u0645\\u0646 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0647\\u0627 \\u0645\\u0639 \\u0623\\u0637\\u0631\\u0627\\u0641 \\u062b\\u0627\\u0644\\u062b\\u0629\\u060c \\u0625\\u0644\\u0627 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629:<\\/p><p>\\u0639\\u0646\\u062f\\u0645\\u0627 \\u064a\\u0642\\u062a\\u0636\\u064a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0630\\u0644\\u0643<br>\\u0644\\u062d\\u0645\\u0627\\u064a\\u0629 \\u062d\\u0642\\u0648\\u0642 \\u0648\\u0633\\u0644\\u0627\\u0645\\u0629 AdCrypto \\u0648\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0647<br>\\u0644\\u0641\\u0631\\u0636 \\u0634\\u0631\\u0648\\u0637 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629 \\u0644\\u062f\\u064a\\u0646\\u0627<\\/p><p>\\u0623\\u0645\\u0646 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a:<\\/p><p>\\u064a\\u0623\\u062e\\u0630 AdCrypto \\u0623\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629 \\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0647 \\u0639\\u0644\\u0649 \\u0645\\u062d\\u0645\\u0644 \\u0627\\u0644\\u062c\\u062f \\u0648\\u0642\\u062f \\u0642\\u0627\\u0645 \\u0628\\u062a\\u0646\\u0641\\u064a\\u0630 \\u0627\\u0644\\u062a\\u062f\\u0627\\u0628\\u064a\\u0631 \\u0627\\u0644\\u0641\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0633\\u0628\\u0629 \\u0644\\u062d\\u0645\\u0627\\u064a\\u062a\\u0647\\u0627. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u064a\\u0631\\u062c\\u0649 \\u0645\\u0644\\u0627\\u062d\\u0638\\u0629 \\u0623\\u0646\\u0647 \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0636\\u0645\\u0627\\u0646 \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u0646\\u0642\\u0644 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0623\\u0648 \\u062a\\u062e\\u0632\\u064a\\u0646\\u0647\\u0627 \\u0622\\u0645\\u0646\\u064b\\u0627 \\u0628\\u0646\\u0633\\u0628\\u0629 100%.<\\/p><p>\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644:<\\/p><p>\\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0644\\u062f\\u064a\\u0643 \\u0623\\u064a \\u0623\\u0633\\u0626\\u0644\\u0629 \\u0623\\u0648 \\u0627\\u0633\\u062a\\u0641\\u0633\\u0627\\u0631\\u0627\\u062a \\u0628\\u062e\\u0635\\u0648\\u0635 \\u0633\\u064a\\u0627\\u0633\\u0629 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 AdCrypto \\u0623\\u0648 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u0646\\u062c\\u0645\\u0639\\u0647\\u0627\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644 \\u0628\\u0646\\u0627 \\u0639\\u0644\\u0649:<\\/p><p>\\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a: support@AdCrypto.com<\\/p><p>\\u0627\\u0644\\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0641\\u064a \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629:<\\/p><p>\\u062a\\u062d\\u062a\\u0641\\u0638 AdCrypto \\u0628\\u0627\\u0644\\u062d\\u0642 \\u0641\\u064a \\u062a\\u0639\\u062f\\u064a\\u0644 \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0647\\u0630\\u0647 \\u0641\\u064a \\u0623\\u064a \\u0648\\u0642\\u062a. \\u0633\\u0646\\u0642\\u0648\\u0645 \\u0628\\u0625\\u062e\\u0637\\u0627\\u0631 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646\\u0627 \\u0628\\u0623\\u064a \\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0645\\u0647\\u0645\\u0629 \\u0639\\u0646 \\u0637\\u0631\\u064a\\u0642 \\u0646\\u0634\\u0631 \\u0625\\u0634\\u0639\\u0627\\u0631 \\u0639\\u0644\\u0649 \\u062a\\u0637\\u0628\\u064a\\u0642\\u0646\\u0627 \\u0623\\u0648 \\u0645\\u0648\\u0642\\u0639\\u0646\\u0627 \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a \\u0648\\u0639\\u0646 \\u0637\\u0631\\u064a\\u0642 \\u062a\\u062d\\u062f\\u064a\\u062b \\u062a\\u0627\\u0631\\u064a\\u062e \\"\\u0622\\u062e\\u0631 \\u062a\\u062d\\u062f\\u064a\\u062b\\" \\u0641\\u064a \\u0627\\u0644\\u062c\\u0632\\u0621 \\u0627\\u0644\\u0639\\u0644\\u0648\\u064a \\u0645\\u0646 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0633\\u064a\\u0627\\u0633\\u0629. \\u0646\\u062d\\u0646 \\u0646\\u0634\\u062c\\u0639 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646\\u0627 \\u0639\\u0644\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0647\\u0630\\u0647 \\u0628\\u0627\\u0646\\u062a\\u0638\\u0627\\u0645 \\u0644\\u0644\\u0628\\u0642\\u0627\\u0621 \\u0639\\u0644\\u0649 \\u0627\\u0637\\u0644\\u0627\\u0639 \\u062d\\u0648\\u0644 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0647\\u0645 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629.<\\/p>"},"fr":{"content":"<p>Politique de confidentialit\\u00e9 pour AdCrypto<\\/p><p>Chez AdCrypto, nous comprenons l\'importance de la confidentialit\\u00e9 et nous nous engageons \\u00e0 prot\\u00e9ger les informations personnelles de nos utilisateurs. Nous croyons en la transparence de nos pratiques de collecte et d\'utilisation des donn\\u00e9es, et cette politique de confidentialit\\u00e9 d\\u00e9crit les informations que nous collectons, la mani\\u00e8re dont nous les utilisons et avec qui nous les partageons.<\\/p><p>Collecte d\'informations&nbsp;:<\\/p><p>AdCrypto collecte les types d\'informations personnelles suivants aupr\\u00e8s de ses utilisateurs&nbsp;:<\\/p><p>Nom<br>Num\\u00e9ro de t\\u00e9l\\u00e9phone<br>Image de profil<\\/p><p>Les informations sont collect\\u00e9es lorsque l\'utilisateur cr\\u00e9e un compte avec AdCrypto ou met \\u00e0 jour les informations de son profil. L\'image de profil est facultative et l\'utilisateur a le choix de la t\\u00e9l\\u00e9charger ou non.<\\/p><p>Utilisation des informations&nbsp;:<\\/p><p>AdCrypto utilise les informations personnelles collect\\u00e9es aupr\\u00e8s de ses utilisateurs aux fins suivantes&nbsp;:<\\/p><p>Pour offrir une exp\\u00e9rience personnalis\\u00e9e \\u00e0 l\'utilisateur<br>Pour envoyer des notifications et des mises \\u00e0 jour sur l\'application<br>Pour am\\u00e9liorer l\'application et ses fonctionnalit\\u00e9s en fonction des commentaires des utilisateurs et des habitudes d\'utilisation<br>Pour se conformer aux obligations l\\u00e9gales et r\\u00e9soudre les litiges<\\/p><p>Partage d\'informations&nbsp;:<\\/p><p>AdCrypto ne partage aucune des informations personnelles collect\\u00e9es aupr\\u00e8s de ses utilisateurs avec des tiers, sauf dans les cas suivants&nbsp;:<\\/p><p>Lorsque la loi l\'exige<br>Pour prot\\u00e9ger les droits et la s\\u00e9curit\\u00e9 d\'AdCrypto et de ses utilisateurs<br>Pour faire respecter nos conditions de service<\\/p><p>S\\u00e9curit\\u00e9 des donn\\u00e9es&nbsp;:<\\/p><p>AdCrypto prend au s\\u00e9rieux la s\\u00e9curit\\u00e9 des informations personnelles de ses utilisateurs et a mis en \\u0153uvre des mesures techniques et organisationnelles appropri\\u00e9es pour les prot\\u00e9ger. Cependant, veuillez noter qu\'aucune transmission ou stockage de donn\\u00e9es ne peut \\u00eatre garanti \\u00e0 100&nbsp;% s\\u00e9curis\\u00e9.<\\/p><p>Coordonn\\u00e9es&nbsp;:<\\/p><p>Si vous avez des questions ou des inqui\\u00e9tudes concernant la politique de confidentialit\\u00e9 d\'AdCrypto ou les informations que nous collectons, vous pouvez nous contacter \\u00e0&nbsp;:<\\/p><p>E-mail&nbsp;: support@adcrypto.com<\\/p><p>Modifications de la politique de confidentialit\\u00e9&nbsp;:<\\/p><p>AdCrypto se r\\u00e9serve le droit de modifier cette politique de confidentialit\\u00e9 \\u00e0 tout moment. Nous informerons nos utilisateurs de tout changement important en publiant un avis sur notre application ou notre site Web et en mettant \\u00e0 jour la date de \\u00ab&nbsp;Derni\\u00e8re mise \\u00e0 jour&nbsp;\\u00bb en haut de cette politique. Nous encourageons nos utilisateurs \\u00e0 consulter r\\u00e9guli\\u00e8rement cette politique de confidentialit\\u00e9 pour rester inform\\u00e9s de la mani\\u00e8re dont nous prot\\u00e9geons leurs informations personnelles.<\\/p>"},"hi":{"content":"<p>AdCrypto \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0928\\u0940\\u0924\\u093f<\\/p><p>AdCrypto \\u092e\\u0947\\u0902, \\u0939\\u092e \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0915\\u0947 \\u092e\\u0939\\u0924\\u094d\\u0935 \\u0915\\u094b \\u0938\\u092e\\u091d\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u0905\\u092a\\u0928\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0940 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092a\\u094d\\u0930\\u0924\\u093f\\u092c\\u0926\\u094d\\u0927 \\u0939\\u0948\\u0902\\u0964 \\u0939\\u092e \\u0905\\u092a\\u0928\\u0947 \\u0921\\u0947\\u091f\\u093e \\u0938\\u0902\\u0917\\u094d\\u0930\\u0939 \\u0914\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u092a\\u094d\\u0930\\u0925\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u092a\\u093e\\u0930\\u0926\\u0930\\u094d\\u0936\\u0940 \\u0939\\u094b\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u0935\\u093f\\u0936\\u094d\\u0935\\u093e\\u0938 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0914\\u0930 \\u092f\\u0939 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0928\\u0940\\u0924\\u093f \\u092c\\u0924\\u093e\\u0924\\u0940 \\u0939\\u0948 \\u0915\\u093f \\u0939\\u092e \\u0915\\u094c\\u0928 \\u0938\\u0940 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u090f\\u0915\\u0924\\u094d\\u0930 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0939\\u092e \\u0907\\u0938\\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0914\\u0930 \\u0939\\u092e \\u0907\\u0938\\u0947 \\u0915\\u093f\\u0938\\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p><p>\\u0938\\u0942\\u091a\\u0928\\u093e \\u0938\\u0902\\u0917\\u094d\\u0930\\u0939:<\\/p><p>AdCrypto \\u0905\\u092a\\u0928\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0938\\u0947 \\u0928\\u093f\\u092e\\u094d\\u0928 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u0940 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u090f\\u0915\\u0924\\u094d\\u0930 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948:<\\/p><p>\\u0928\\u093e\\u092e<br>\\u092b\\u093c\\u094b\\u0928 \\u0928\\u0902\\u092c\\u0930<br>\\u092a\\u094d\\u0930\\u094b\\u092b\\u093c\\u093e\\u0907\\u0932 \\u091b\\u0935\\u093f<\\/p><p>\\u091c\\u092c \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e AdCrypto \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0916\\u093e\\u0924\\u093e \\u092c\\u0928\\u093e\\u0924\\u093e \\u0939\\u0948 \\u092f\\u093e \\u0905\\u092a\\u0928\\u0940 \\u092a\\u094d\\u0930\\u094b\\u092b\\u093c\\u093e\\u0907\\u0932 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0905\\u092a\\u0921\\u0947\\u091f \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u0924\\u094b \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u090f\\u0915\\u0924\\u094d\\u0930 \\u0915\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u092a\\u094d\\u0930\\u094b\\u092b\\u093c\\u093e\\u0907\\u0932 \\u091b\\u0935\\u093f \\u0935\\u0948\\u0915\\u0932\\u094d\\u092a\\u093f\\u0915 \\u0939\\u0948, \\u0914\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0947 \\u092a\\u093e\\u0938 \\u0907\\u0938\\u0947 \\u0905\\u092a\\u0932\\u094b\\u0921 \\u0915\\u0930\\u0928\\u0947 \\u092f\\u093e \\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p><p>\\u0938\\u0942\\u091a\\u0928\\u093e \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917:<\\/p><p>AdCrypto \\u0905\\u092a\\u0928\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0938\\u0947 \\u090f\\u0915\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0940 \\u0917\\u0908 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0928\\u093f\\u092e\\u094d\\u0928\\u0932\\u093f\\u0916\\u093f\\u0924 \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948:<\\/p><p>\\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u094b \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u0905\\u0928\\u0941\\u092d\\u0935 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0928\\u093e<br>\\u0910\\u092a \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u0942\\u091a\\u0928\\u093e\\u090f\\u0901 \\u0914\\u0930 \\u0905\\u092a\\u0921\\u0947\\u091f \\u092d\\u0947\\u091c\\u0928\\u093e<br>\\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0940 \\u092a\\u094d\\u0930\\u0924\\u093f\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0914\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u092a\\u0948\\u091f\\u0930\\u094d\\u0928 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0910\\u092a \\u0914\\u0930 \\u0907\\u0938\\u0915\\u0940 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u0913\\u0902 \\u0915\\u094b \\u092c\\u0947\\u0939\\u0924\\u0930 \\u092c\\u0928\\u093e\\u0928\\u093e<br>\\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0926\\u093e\\u092f\\u093f\\u0924\\u094d\\u0935\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0928\\u093e \\u0914\\u0930 \\u0935\\u093f\\u0935\\u093e\\u0926\\u094b\\u0902 \\u0915\\u094b \\u0939\\u0932 \\u0915\\u0930\\u0928\\u093e<\\/p><p>\\u0938\\u0942\\u091a\\u0928\\u093e \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0928\\u093e:<\\/p><p>AdCrypto \\u0905\\u092a\\u0928\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0938\\u0947 \\u090f\\u0915\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0940 \\u0917\\u0908 \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u094b \\u0924\\u0940\\u0938\\u0930\\u0947 \\u092a\\u0915\\u094d\\u0937 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0938\\u093e\\u091d\\u093e \\u0928\\u0939\\u0940\\u0902 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u0938\\u093f\\u0935\\u093e\\u092f \\u0928\\u093f\\u092e\\u094d\\u0928\\u0932\\u093f\\u0916\\u093f\\u0924 \\u092e\\u093e\\u092e\\u0932\\u094b\\u0902 \\u092e\\u0947\\u0902:<\\/p><p>\\u091c\\u092c \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0939\\u094b<br>AdCrypto \\u0914\\u0930 \\u0909\\u0938\\u0915\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0940 \\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u093e<br>\\u0939\\u092e\\u093e\\u0930\\u0940 \\u0938\\u0947\\u0935\\u093e \\u0915\\u0940 \\u0936\\u0930\\u094d\\u0924\\u094b\\u0902 \\u0915\\u094b \\u0932\\u093e\\u0917\\u0942 \\u0915\\u0930\\u0928\\u093e<\\/p><p>\\u0921\\u0947\\u091f\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e:<\\/p><p>AdCrypto \\u0905\\u092a\\u0928\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0940 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u094b \\u0917\\u0902\\u092d\\u0940\\u0930\\u0924\\u093e \\u0938\\u0947 \\u0932\\u0947\\u0924\\u093e \\u0939\\u0948 \\u0914\\u0930 \\u0907\\u0938\\u0947 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0916\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0909\\u091a\\u093f\\u0924 \\u0924\\u0915\\u0928\\u0940\\u0915\\u0940 \\u0914\\u0930 \\u0938\\u0902\\u0917\\u0920\\u0928\\u093e\\u0924\\u094d\\u092e\\u0915 \\u0909\\u092a\\u093e\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0932\\u093e\\u0917\\u0942 \\u0915\\u093f\\u092f\\u093e \\u0939\\u0948\\u0964 \\u0939\\u093e\\u0932\\u093e\\u0901\\u0915\\u093f, \\u0915\\u0943\\u092a\\u092f\\u093e \\u0927\\u094d\\u092f\\u093e\\u0928 \\u0926\\u0947\\u0902 \\u0915\\u093f \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0921\\u0947\\u091f\\u093e \\u091f\\u094d\\u0930\\u093e\\u0902\\u0938\\u092e\\u093f\\u0936\\u0928 \\u092f\\u093e \\u0938\\u094d\\u091f\\u094b\\u0930\\u0947\\u091c \\u0915\\u0940 100% \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0940 \\u0917\\u093e\\u0930\\u0902\\u091f\\u0940 \\u0928\\u0939\\u0940\\u0902 \\u0926\\u0940 \\u091c\\u093e \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p><p>\\u0938\\u0902\\u092a\\u0930\\u094d\\u0915 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940:<\\/p><p>\\u092f\\u0926\\u093f \\u0906\\u092a\\u0915\\u0947 \\u092a\\u093e\\u0938 AdCrypto \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0928\\u0940\\u0924\\u093f \\u092f\\u093e \\u0939\\u092e\\u093e\\u0930\\u0947 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u090f\\u0915\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0940 \\u0917\\u0908 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0915\\u094b\\u0908 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928 \\u092f\\u093e \\u091a\\u093f\\u0902\\u0924\\u093e \\u0939\\u0948, \\u0924\\u094b \\u0906\\u092a \\u0939\\u092e\\u0938\\u0947 \\u0938\\u0902\\u092a\\u0930\\u094d\\u0915 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902:<\\/p><p>\\u0908\\u092e\\u0947\\u0932: support@adrypto.com<\\/p><p>\\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0928\\u0940\\u0924\\u093f \\u092e\\u0947\\u0902 \\u092a\\u0930\\u093f\\u0935\\u0930\\u094d\\u0924\\u0928:<\\/p><p>AdCrypto \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0938\\u092e\\u092f \\u0907\\u0938 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0928\\u0940\\u0924\\u093f \\u0915\\u094b \\u0938\\u0902\\u0936\\u094b\\u0927\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0916\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0939\\u092e \\u0905\\u092a\\u0928\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u0905\\u092a\\u0928\\u0947 \\u0910\\u092a \\u092f\\u093e \\u0935\\u0947\\u092c\\u0938\\u093e\\u0907\\u091f \\u092a\\u0930 \\u090f\\u0915 \\u0928\\u094b\\u091f\\u093f\\u0938 \\u092a\\u094b\\u0938\\u094d\\u091f \\u0915\\u0930\\u0915\\u0947 \\u0914\\u0930 \\u0907\\u0938 \\u0928\\u0940\\u0924\\u093f \\u0915\\u0947 \\u0936\\u0940\\u0930\\u094d\\u0937 \\u092a\\u0930 \\"\\u0905\\u0902\\u0924\\u093f\\u092e \\u0905\\u092a\\u0921\\u0947\\u091f\\" \\u0924\\u093f\\u0925\\u093f \\u0915\\u094b \\u0905\\u092a\\u0921\\u0947\\u091f \\u0915\\u0930\\u0915\\u0947 \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0930\\u093f\\u0935\\u0930\\u094d\\u0924\\u0928 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u0942\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0917\\u0947\\u0964 \\u0939\\u092e \\u0905\\u092a\\u0928\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u0907\\u0938 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0928\\u0940\\u0924\\u093f \\u0915\\u0940 \\u0928\\u093f\\u092f\\u092e\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092a\\u094d\\u0930\\u094b\\u0924\\u094d\\u0938\\u093e\\u0939\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0924\\u093e\\u0915\\u093f \\u0935\\u0947 \\u0907\\u0938 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u0942\\u091a\\u093f\\u0924 \\u0930\\u0939\\u0947\\u0902 \\u0915\\u093f \\u0939\\u092e \\u0909\\u0928\\u0915\\u0940 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930 \\u0930\\u0939\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>"}}}','status' => '1','editable' => '0','created_at' => '2023-11-19 06:50:17','updated_at' => '2024-11-16 13:36:21')
        );
          
        UsefulLink::insert($useful_links);
    }
}
