<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Database\Seeders\User\UserSeeder;
use Database\Seeders\Admin\BlogSeeder;
use Database\Seeders\Admin\CoinSeeder;
use Database\Seeders\Admin\RoleSeeder;
use Database\Seeders\Admin\AdminSeeder;
use Database\Seeders\Admin\NetworkSeeder;
use Database\Seeders\Admin\CurrencySeeder;
use Database\Seeders\Admin\LanguageSeeder;
use Database\Seeders\Admin\SetupKycSeeder;
use Database\Seeders\Admin\SetupSeoSeeder;
use Database\Seeders\Admin\ExtensionSeeder;
use Database\Seeders\Admin\SetupPageSeeder;
use Database\Seeders\Admin\UsefulLinkSeeder;
use Database\Seeders\Admin\AppSettingsSeeder;
use Database\Seeders\Admin\AdminHasRoleSeeder;
use Database\Seeders\Admin\SiteSectionsSeeder;
use Database\Seeders\Admin\BasicSettingsSeeder;
use Database\Seeders\Admin\PaymentGatewaySeeder;
use Database\Seeders\Admin\AppOnboardScreenSeeder;
use Database\Seeders\Admin\LiveExchangeRateSeeder;
use Database\Seeders\Admin\SystemMaintenanceSeeder;
use Database\Seeders\Admin\FreshBasicSettingsSeeder;
use Database\Seeders\Admin\TransactionSettingSeeder;
use Database\Seeders\Admin\OutsideWalletAddressSeeder;
use Database\Seeders\Admin\VirtualApiSeeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // fresh
        $this->call([
            AdminSeeder::class,
            RoleSeeder::class,
            TransactionSettingSeeder::class,
            FreshBasicSettingsSeeder::class,
            AppOnboardScreenSeeder::class,
            SetupSeoSeeder::class,
            AppSettingsSeeder::class,
            SiteSectionsSeeder::class,
            SetupKycSeeder::class,
            ExtensionSeeder::class,
            AdminHasRoleSeeder::class,
            SetupPageSeeder::class,
            PaymentGatewaySeeder::class,
            LanguageSeeder::class,
            UsefulLinkSeeder::class,
            BlogSeeder::class,
            CoinSeeder::class,
            NetworkSeeder::class,
            CurrencySeeder::class,
            OutsideWalletAddressSeeder::class,
            SystemMaintenanceSeeder::class,
            LiveExchangeRateSeeder::class,
            VirtualApiSeeder::class,
        ]);

        // demo
        // $this->call([
        //     AdminSeeder::class,
        //     RoleSeeder::class,
        //     TransactionSettingSeeder::class,
        //     BasicSettingsSeeder::class,
        //     AppOnboardScreenSeeder::class,
        //     SetupSeoSeeder::class,
        //     AppSettingsSeeder::class,
        //     SiteSectionsSeeder::class,
        //     SetupKycSeeder::class,
        //     ExtensionSeeder::class,
        //     AdminHasRoleSeeder::class,
        //     UserSeeder::class,
        //     SetupPageSeeder::class,
        //     PaymentGatewaySeeder::class,
        //     LanguageSeeder::class,
        //     UsefulLinkSeeder::class,
        //     BlogSeeder::class,
        //     CoinSeeder::class,
        //     NetworkSeeder::class,
        //     CurrencySeeder::class,
        //     OutsideWalletAddressSeeder::class,
        //     SystemMaintenanceSeeder::class,
        //     LiveExchangeRateSeeder::class,
        //     VirtualApiSeeder::class,
        // ]);
    }
}
