@extends('admin.layouts.master')

@push('css')

    <style>
        .fileholder {
            min-height: 374px !important;
        }

        .fileholder-files-view-wrp.accept-single-file .fileholder-single-file-view,.fileholder-files-view-wrp.fileholder-perview-single .fileholder-single-file-view{
            height: 330px !important;
        }
    </style>
@endpush

@section('page-title')
    @include('admin.components.page-title',['title' => __($page_title)])
@endsection

@section('breadcrumb')
    @include('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ],

    ], 'active' => __("Exchange Crypto Log Details")])
@endsection

@section('content')
<div class="row mb-30-none">

    <div class="col-lg-12 mb-30">
        <div class="transaction-area">
            <h4 class="title mb-0"><i class="fas fa-user text--base me-2"></i>{{ __("Card Information") }}</h4>
            <div class="content pt-0">
                <div class="list-wrapper">
                    <ul class="list">
                        <li>{{ __("Card Holder Name") }}<span>{{ $transaction->details->card_info->card_name ?? '' }}</span></li>
                        <li>{{ __("Card Currency") }}<span>{{ $transaction->details->card_info->currency ?? '' }}</span></li>
                        <li>{{ __("ENV Type") }}<span>{{ $transaction->details->card_info->env ?? "" }}</span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-12 mb-30">
        <div class="transaction-area">
            <div class="d-flex justify-content-between align-items-center">
                <h4 class="title"><i class="fas fa-user text--base me-2"></i>{{ __("Payment Summary") }}</h4>
            </div>
            <div class="content pt-0">
                <div class="list-wrapper">
                    <ul class="list">
                        <li>{{ __("Transaction Number") }} <span>{{ $transaction->trx_id ?? ''  }}</span> </li>
                        <li>{{ __("Transaction Type") }} <span>{{ $transaction->type ?? ''  }}</span> </li>
                        @if ($transaction->remark != "CARD-BUY")
                            <li>{{ __("Amount") }} <span>{{ get_amount($transaction->amount,$transaction->currency_code)  }}</span> </li>
                        @endif
                        <li>{{ __("Exchange Rate") }} <span> 1 {{ $transaction->currency_code }} = {{ get_amount($transaction->details->charges->exchange_rate,$transaction->user_wallets->currency->code,8)  }}</span> </li>
                        <li>{{ __("Total Charge") }} <span>{{ get_amount($transaction->total_charge,$transaction->user_wallets->currency->code,8)  }}</span> </li>
                        @if ($transaction->remark == "CARD-WITHDRAW")
                            <li>{{ __("Will Get") }} <span>{{ get_amount($transaction->total_payable,$transaction->user_wallets->currency->code,8)  }}</span> </li>
                        @else
                            <li>{{ __("Total Payable") }} <span>{{ get_amount($transaction->total_payable,$transaction->user_wallets->currency->code,8)  }}</span> </li>
                        @endif
                        <li>{{ __("Remark") }} <span>{{ $transaction->remark ?? 'N/A' }}</span></li>
                        <li>
                            {{ __("Status") }}
                            <span>
                                @if ($transaction->status  == global_const()::STATUS_PENDING)
                                    <p>{{ __("Pending") }}</p>
                                @elseif($transaction->status  == global_const()::STATUS_CONFIRM_PAYMENT)
                                    <p>{{ __("Success") }}</p>
                                @elseif($transaction->status  == global_const()::STATUS_REJECT)
                                    <p>{{ __("Rejected") }}</p>
                                @endif
                            </span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
