@php
    $app_local      = get_default_language_code();
    $default        = App\Constants\LanguageConst::NOT_REMOVABLE;
    $slug           = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::CONTACT_SECTION);
    $contact        = App\Models\Admin\SiteSections::getData($slug)->first();
@endphp

@extends('frontend.layouts.master')

@section('content')


<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Contact
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<div class="contact-section section--bg ptb-120">
    <div class="container">
        <div class="contact-area">
            <div class="contact-wrapper">
                <div class="row justify-content-center align-items-center mb-30-none">
                    <div class="col-xl-6 col-lg-6 mb-30">
                        <div class="contact-thumb">
                            <img src="{{ get_image(@$contact->value->image , 'site-section') }}" alt="element">
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 mb-30">
                        <div class="contact-form-area">
                            <div class="section-header">
                                <span class="title-badge">$</span>
                                <h5 class="section-sub-title">{{ $contact->value->language->$app_local->title ?? $contact->value->language->$default->title ?? '' }}</h5>
                                @php
                                    $heading    = explode('|' , $contact->value->language->$app_local->heading ?? $contact->value->language->$default->heading ?? "" );
                                @endphp
                                <h2 class="section-title">{{ isset($heading[0]) ? $heading[0] : '' }} <span>{{ isset($heading[1]) ? $heading[1] : '' }}</span></h2>
                            </div>
                            <form class="contact-form" action="{{ setRoute('contact.request') }}" method="POST">
                                @csrf
                                <div class="row justify-content-center mb-10-none">
                                    <div class="col-xl-6 col-lg-6 col-md-12 form-group">
                                        <label>{{ __("Name") }}<span>*</span></label>
                                        <input type="text" name="name" class="form--control" placeholder="{{ __("Enter Name") }}...">
                                    </div>
                                    <div class="col-xl-6 col-lg-6 col-md-12 form-group">
                                        <label>{{ __("Email") }}<span>*</span></label>
                                        <input type="email" name="email" class="form--control" placeholder="{{ __("Enter Email") }}...">
                                    </div>
                                    <div class="col-xl-12 col-lg-12 form-group">
                                        <label>{{ __("Message") }}<span>*</span></label>
                                        <textarea class="form--control" name="message" placeholder="{{ __("Write Here") }}..."></textarea>
                                    </div>
                                    <x-security.google-recaptcha-field />
                                    <div class="col-lg-12 form-group">
                                        <button type="submit" class="btn--base mt-10"><span>{{ __("Send Message") }}</span></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End Contact
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

@foreach ($page_section->sections ?? [] as $item)
    @if ($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::BANNER_SECTION))
        @include('frontend.sections.banner')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::SECURITY_SECTION))
        @include('frontend.sections.security')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::HOW_ITS_WORK_SECTION))
        @include('frontend.sections.how-its-work')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::DOWNLOAD_APP_SECTION))
        @include('frontend.sections.download-app')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::STATISTIC_SECTION))
        @include('frontend.sections.statistics')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::CALL_TO_ACTION_SECTION))
        @include('frontend.sections.call-to-action')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::ABOUT_SECTION))
        @include('frontend.sections.about')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::FAQ_SECTION))
        @include('frontend.sections.faq')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::SERVICE_SECTION))
        @include('frontend.sections.service')
    @endif
@endforeach

@endsection
