@php
    $app_local      = get_default_language_code();
    $default        = App\Constants\LanguageConst::NOT_REMOVABLE;
@endphp
@extends('frontend.layouts.master')

@push("css")
    
@endpush

@section('content') 

<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Blog
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<section class="blog-section section--bg ptb-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-6 col-lg-8 text-center">
                <div class="section-header">
                    <span class="title-badge">$</span>
                    <h5 class="section-sub-title">{{ $web_journal->value->language->$app_local->title ?? $web_journal->value->language->$default->title ?? "" }}</h5>
                    @php
                        $heading    = explode('|' , $web_journal->value->language->$app_local->heading ?? $web_journal->value->language->$default->heading ?? "" );
                    @endphp
                    <h2 class="section-title">{{ isset($heading[0]) ? $heading[0] : '' }} <span>{{ isset($heading[1]) ? $heading[1] : '' }}</span></h2>
                </div>
            </div>
        </div>
        <div class="row justify-content-center mb-30-none">
            @foreach ($blogs ?? [] as $item)
                <div class="col-xl-4 col-lg-6 col-md-6 mb-30">
                    <div class="blog-item">
                        <div class="blog-thumb">
                            <img src="{{ get_image($item->data->image ,'site-section') }}" alt="blog">
                        </div>
                        <div class="blog-content">
                           
                            <span class="date"><i class="las la-calendar"></i> {{ \Carbon\Carbon::parse($item->created_at)->format('F j, Y') }}</span>
                            <h5 class="title"><a href="{{ setRoute('journal.details',$item->slug) }}">{{ Str::words($item->data->language->$app_local->title ?? "","5","...") }}</a></h5>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        @if (count($blogs) > 6)
        <div class="view-more-btn text-center mt-60">
            <a href="{{ setRoute('journals') }}" class="btn--base">{{ __("View More") }}</a>
        </div>
        @endif
    </div>
</section>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End Blog
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
@foreach ($page_section->sections ?? [] as $item)
    @if ($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::BANNER_SECTION))
        @include('frontend.sections.banner')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::SECURITY_SECTION))
        @include('frontend.sections.security')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::HOW_ITS_WORK_SECTION))
        @include('frontend.sections.how-its-work')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::DOWNLOAD_APP_SECTION))
        @include('frontend.sections.download-app')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::STATISTIC_SECTION))
        @include('frontend.sections.statistics')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::CALL_TO_ACTION_SECTION))
        @include('frontend.sections.call-to-action')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::ABOUT_SECTION))
        @include('frontend.sections.about')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::FAQ_SECTION))
        @include('frontend.sections.faq')
    @elseif($item->section->key == Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::SERVICE_SECTION))
        @include('frontend.sections.service')
    @endif
@endforeach
@endsection