@extends('user.layouts.master')

@section('breadcrumb')
    @include('user.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("user.dashboard"),
        ]
    ], 'active' => __("2FA Security")])
@endsection

@section('content')

<div class="body-wrapper">
    <div class="row mt-30 mb-20-none">
        <div class="col-xl-6 col-lg-6 mb-20">
            <div class="custom-card">
                <div class="dashboard-header-wrapper">
                    <h5 class="title">{{ __("Two Factor Authenticator") }}</h5>
                </div>
                <div class="card-body">
                    <form class="card-form">
                        <div class="row">
                            <div class="col-xl-12 col-lg-12 form-group">
                                <label>{{ __("Address") }}<span>*</span></label>
                                <div class="input-group">
                                    <input type="text" class="form--control" id="referralURL" value="{{ auth()->user()->two_factor_secret }}" readonly>
                                    <div class="input-group-text copytext"><i class="las la-copy"></i></div>
                                </div>
                            </div>
                            <div class="col-xl-12 col-lg-12 form-group">
                                <div class="qr-code-thumb text-center">
                                    <img class="mx-auto" src="{{ $qr_code }}">
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-12 col-lg-12">
                            @if (auth()->user()->two_factor_status)
                            <button type="button" class="btn--base bg--warning w-100 active-deactive-btn">{{ __("Disable") }}</button>
                            <br>
                            <div class="text--danger mt-3">{{ __("Don't forget to add this application in your google authentication app. Otherwise you can't login in your account.") }}</div>
                            @else
                            <button type="button" class="btn--base w-100 active-deactive-btn"><span class="w-100">{{ __("Enable") }}</span></button>
                            @endif
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-xl-6 col-lg-6 mb-20">
            <div class="custom-card">
                <div class="dashboard-header-wrapper">
                    <h5 class="title">{{ __("Google Authenticator") }}</h5>
                </div>
                <div class="card-body">
                    <h6 class="mb-3">{{ __("Download Google Authenticator App") }}</h6>
                    <p>{{ __("Google Authenticator adds an extra layer of security to your online accounts by adding a second step of verification when you sign in. This means that in addition to your password, you'll also need to enter a code that is generated by the Google Authenticator app on your phone.") }} <a href="https://support.google.com/accounts/answer/1066447?hl=en&co=GENIE.Platform=Android" target="_blank" class="text--base">{{ __("How to Setup?") }}</a></p>
                    <div class="autenticator-store-thumb text-center mb-20">
                        <img class="mx-auto" src="{{ get_image('frontend/images/element/autenticator.png') }}">
                    </div>
                    <a href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2" class="btn--base mt-10 w-100"><span class="w-100">{{ __("Download App") }}</span></a>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@push('script')
    <script>
        $(".active-deactive-btn").click(function(){
            var actionRoute =  "{{ setRoute('user.security.google.2fa.status.update') }}";
            var target      = 1;
            var btnText = $(this).text();
            var message     = `{{ __("Are you sure to") }} <strong>${btnText}</strong> {{ __("2 factor authentication (Powered by google)?") }}`;
            openAlertModal(actionRoute,target,message,btnText,"POST");
        });

        // copy text
        $('.copytext').on('click',function(){
            var copyText = document.getElementById("referralURL");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            document.execCommand("copy");

            throwMessage('success',["Copied: " + copyText.value]);
        });
    </script>
@endpush
