@extends('user.layouts.master')

@push('css')
    <style>
        .process-step.disabled {
            pointer-events: none;
            opacity: 0.5;
            cursor: not-allowed;
        }
        .process-step.disabled {
            pointer-events: none;
            opacity: 0.5;
            cursor: not-allowed;
        }
       .add-cards-section-wrapper .card-balance {
            font-size: 20px;
            font-weight: 700;
            text-align: right !important ;
        }
        .add-cards-section-wrapper .card-number-text {
            font-size: 16px !important;
            font-weight: 600;
            margin-bottom: 4px;
            color: white;
        }
        .saved-cards-container .card-container {
            width: auto;
            min-width: 280px;
            max-width: 280px !important;
            height: 200px;
            border-radius: 16px;
            position: relative;
            overflow: hidden;
            cursor: pointer;
            -webkit-transition: -webkit-transform 0.3s ease;
            transition: -webkit-transform 0.3s ease;
            transition: transform 0.3s ease;
            transition: transform 0.3s ease, -webkit-transform 0.3s ease;
        }
    </style>
@endpush

@section('breadcrumb')
    @include('user.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('user.dashboard'),
            ],
        ],
        'active' => __('Create Card Customer'),
    ])
@endsection

@section('content')
    <div class="body-wrapper">
        <div class="dashboard-area mt-20">
            <div class="add-cards-section-wrapper">
                <div class="container-fluid py-4">
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <div class="process-container p-4">
                                <div class="process-header text-center mb-4">
                                    <h4 class="mb-3">{{ __('Create Your Card') }}</h4>
                                    <div class="process-steps d-flex justify-content-center align-items-center">
                                        <div class="process-step active" data-step="1">
                                            <div class="step-number">1</div>
                                            <div class="step-title">{{ __('Choose Type') }}</div>
                                        </div>
                                        <div class="process-line"></div>
                                        <div class="process-step step-two disabled" data-step="2">
                                            <div class="step-number">2</div>
                                            <div class="step-title">{{ __('Card Details') }}</div>
                                        </div>
                                        <div class="process-line"></div>
                                        <div class="process-step step-three disabled" data-step="3">
                                            <div class="step-number">3</div>
                                            <div class="step-title">{{ __('Completed') }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--step 1 -->
                <div class="step-1">
                    <div class="container-fluid py-5">
                        <div class="row justify-content-center">
                            <!-- Universal Card -->
                            <div class=" col-lg-4 col-md-5 col-sm-6 col-12 ">
                                <div class="card-type-container universal-card" data-card-type="universal">
                                    <!-- Card Preview -->
                                    <div class="card-preview">
                                        <div class="card-info">
                                            <div class="card-logo mb-60">
                                                <img src="{{ get_fav($basic_settings) ?? "" }}"
                                                    alt="card-provider-logo">
                                            </div>
                                        </div>
                                        <div class="card-info">
                                            <div class="card-number-text">{{ __('Card Number') }}</div>
                                            <div class="card-holder-text">{{ __('Holder Name') }}</div>
                                        </div>
                                        <div class="card-type">
                                            <h3 class="card-balance">{{ __('Universal') }}</h3>
                                        </div>
                                    </div>

                                    <!-- Feature Tags -->
                                    <div class="feature-tags">
                                        <span class="feature-tag">{{ __('Card Issue Fee') }} : {{ $card_currencies->first()->currency_symbol }}{{ $card_currencies->first()->fees->cardyfie_universal_card_issues_fee }}</span>
                                    </div>

                                </div>
                            </div>

                            <!-- Platinum Card -->
                            <div class="col-lg-4 col-md-5 col-sm-6 col-12">
                                <div class="card-type-container platinum-card" data-card-type="platinum">
                                    <!-- Card Preview -->
                                    <div class="card-preview">
                                        <div class="card-info">
                                            <div class="card-logo mb-60">
                                                <img src="{{ get_fav($basic_settings) ?? "" }}"
                                                    alt="card-provider-logo">
                                            </div>
                                        </div>
                                        <div class="card-info">
                                            <div class="card-number-text">{{ __('Card Number') }}</div>
                                            <div class="card-holder-text">{{ __('Holder Name') }}</div>
                                        </div>
                                        <div class="card-type">
                                            <h3 class="card-balance">{{ __('Platinum') }}</h3>
                                        </div>
                                    </div>

                                    <!-- Feature Tags -->
                                    <div class="feature-tags">
                                        <span class="feature-tag">{{ __('Card Issue Fee') }} : {{ $card_currencies->first()->currency_symbol }}{{ $card_currencies->first()->fees->cardyfie_platinum_card_issues_fee }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row justify-content-center mt-4">
                            <div class="col-lg-8 col-md-10 ">
                                <div class="d-flex justify-content-between">
                                    <button type="button" class="btn btn-back">{{ __('Back') }}</button>
                                    <button type="button" class="btn btn-next step-two disabled">{{ __('Next') }}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="step-2">
                    <div class="container-fluid py-4">
                        <div class="row justify-content-center ">
                            <!-- Left Side - Card Preview -->
                            <div class="col-md-4 mb-4">
                                <div class="card-preview">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="card-logo">
                                            <img src="{{ get_fav($basic_settings) ?? "" }}"
                                                alt="card-provider-logo">
                                        </div>
                                    </div>
                                    <div>
                                        <div class="card-number" id="previewCardNumber">****************</div>
                                        <div class="card-holder" id="previewCardHolder">{{ __('Card Holder Name') }}</div>
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="card-balance balance-preview" id="previewBalance">--</div>
                                        <img src="{{ get_image('frontend/images/card/visa_5968299.svg') }}"
                                            alt="Visa" class="card-brand-logo" id="previewBrandLogo">
                                    </div>
                                </div>

                                <!-- Fee Information -->
                                <div class=" fees-container ">
                                    <div class="fee-row">
                                        <span class="fee-label">{{ __('Exchange Rate') }}</span>
                                        <span class="fee-value text-white exchange-rate">--</span>
                                    </div>
                                    <div class="fee-row">
                                        <span class="fee-label">{{ __('Card Issue Fee') }}</span>
                                        <span class="fee-value text-white issue-fee">--</span>
                                    </div>
                                    <div class="fee-row">
                                        <span class="fee-label">{{ __('Total Payable Amount') }}</span>
                                        <span class="fee-value text-white total-amount">--</span>
                                    </div>
                                </div>
                            </div>

                            <!-- Right Side - Form -->
                            <div class="col-md-6">
                                <div class="step-wrapper p-4 rounded shadow-sm">
                                    <div class="row">
                                        <div class="col-md-12 mb-3">
                                            <label for="cardName"
                                                class="form-label">{{ __("Card Holder's Name") }}</label>
                                            <input type="text" class="form-control" name="card_holder_name"
                                                id="cardName" placeholder="{{ __('Enter card name') }}">
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">{{ __('Provider') }}</label>
                                        <div class="row">
                                            <div class="col-md-6 mb-2">
                                                <div class="provider-option selected" data-provider="visa">
                                                    <img src="{{ get_image('frontend/images/card/visa_5968299.svg') }}"
                                                        alt="Visa" class="provider-logo">
                                                    <span>{{ __('Visa') }}</span>
                                                </div>
                                            </div>
                                            <div class="col-md-6 mb-2">
                                                <div class="provider-option" data-provider="mastercard">
                                                    <img src="{{ get_image('frontend/images/card/mastercard-svg.svg') }}"
                                                        alt="Mastercard" class="provider-logo">
                                                    <span>{{ __('Mastercard') }}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="selectWallet"
                                                class="form-label">{{ __('Select Wallet') }}</label>
                                            <select class="form-select nice-select" name="wallet_currency" id="selectWallet" required>
                                                <option value="" selected disabled>{{ __('Choose Wallet') }}</option>
                                                @forelse ($wallets as $wallet)
                                                    <option value="{{ $wallet->id }}"
                                                        data-rate="{{ $wallet->currency->rate }}"
                                                        data-currency-code="{{ $wallet->currency->code }}"
                                                        data-currency-symbol="{{ $wallet->currency->symbol }}">
                                                        {{ $wallet->currency->name }}</option>
                                                @empty
                                                @endforelse
                                            </select>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label for="cardCurrency"
                                                class="form-label">{{ __('Card Currency') }}</label>
                                            <select class="form-select nice-select" name="card_currency"
                                                id="cardCurrency" required>
                                                <option value="" selected disabled>{{ __('Select Currency') }}</option>
                                                @forelse ($card_currencies as $currency)
                                                    <option value="{{ $currency->id }}"
                                                        data-currency-code="{{ $currency->currency_code }}"
                                                        data-rate="{{ $currency->rate }}"
                                                        data-min-limit="{{ $currency->min_limit }}"
                                                        data-max-limit="{{ $currency->max_limit }}"
                                                        data-daily-limit="{{ $currency->daily_limit }}"
                                                        data-monthly-limit="{{ $currency->monthly_limit }}"
                                                        data-universal-package-fee="{{ $currency->fees->cardyfie_universal_card_issues_fee }}"
                                                        data-platinum-package-fee="{{ $currency->fees->cardyfie_platinum_card_issues_fee }}"
                                                        data-card-deposit-fixed-fee="{{ $currency->fees->cardyfie_card_deposit_fixed_fee }}"
                                                        data-card-withdraw-fixed-fee="{{ $currency->fees->cardyfie_card_withdraw_fixed_fee }}"
                                                        data-card-maintenance-fixed-fee="{{ $currency->fees->cardyfie_card_maintenance_fixed_fee }}"
                                                        data-currency-symbol="{{ $currency->currency_symbol }}">
                                                        {{ $currency->currency_code }}</option>
                                                @empty
                                                @endforelse
                                            </select>
                                        </div>
                                    </div>

                                    {{-- <div class="prohibited-section">
                                        <div class="prohibited-title">Prohibited merchants applies to this card</div>
                                        <div class="prohibited-text">
                                            Fund cryptocurrency exchanges, brokers and gambling platforms or any other
                                            services,
                                            outside of the card category are strictly prohibited.
                                        </div>
                                    </div> --}}
                                </div>
                            </div>
                        </div>
                        <div class="row justify-content-center mt-4">
                            <div class="col-md-10">
                                <div class="d-flex justify-content-between">
                                    <button type="button" class="btn btn-back">{{ __('Back') }}</button>
                                    <button type="button" class="btn btn-issue issue-card disabled">{{ __('Issue Card') }}</button>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="step-3">
                    <div class="container-fluid py-4 ">
                        <div class="row justify-content-center ">
                            <!-- Right Side - Form -->
                            <div class="col-md-4 col-sm-6   ">
                                <div class="bg-cc-card p-4 shadow-sm justify-content-center ">
                                    <div class="prohibited-section">
                                        <div class="prohibited-title">{{ __('Card Issue Complete') }}</div>
                                        <div class="links-wrapper d-flex justify-content-between mt-4">
                                            <a href="{{ route('user.cardyfie.virtual.card.create') }}">
                                                {{ __('Issues More') }}
                                            </a>
                                            <a href="{{ route('user.cardyfie.virtual.card.index') }}">
                                                {{ __('Go To Cards') }}
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('script')
    <script>
        // Card selection functionality
        document.querySelectorAll('.card-type-container').forEach(card => {
            card.addEventListener('click', function() {
                // Remove selected class from all cards
                document.querySelectorAll('.card-type-container').forEach(c => {
                    c.classList.remove('selected');
                });

                // Add selected class to clicked card
                this.classList.add('selected');

                // Get selected card type
                const cardType = this.getAttribute('data-card-type');
                console.log('Selected card type:', cardType);
            });
        });
    </script>
    <script>
        // Provider selection
        document.querySelectorAll('.provider-option').forEach(option => {
            option.addEventListener('click', function() {
                // Remove selected class from all options
                document.querySelectorAll('.provider-option').forEach(opt => {
                    opt.classList.remove('selected');
                });

                // Add selected class to clicked option
                this.classList.add('selected');

                // Update preview card brand logo
                const provider = this.getAttribute('data-provider');
                const previewLogo = document.getElementById('previewBrandLogo');

                if (provider === 'visa') {
                    previewLogo.src = "{{ get_image('frontend/images/card/visa_5968299.svg') }}";
                    previewLogo.alt = 'Visa';
                } else if (provider === 'mastercard') {
                    previewLogo.src = "{{ get_image('frontend/images/card/mastercard-svg.svg') }}";
                    previewLogo.alt = 'Mastercard';
                }
            });
        });

        // Update card preview when card name changes
        document.getElementById('cardName').addEventListener('input', function() {
            const cardHolder = document.getElementById('previewCardHolder');
            cardHolder.textContent = this.value || 'Card Holder Name';
        });

        // // Update card preview when amount changes
        // document.getElementById('cardAmount').addEventListener('input', function() {
        //     const balance = document.getElementById('previewBalance');
        //     const amount = parseFloat(this.value) || 0;
        //     balance.textContent = `$${amount.toFixed(2)}`;
        // });

        // Button event handlers
        document.querySelector('.btn-back').addEventListener('click', function() {
            console.log('Back button clicked');
        });

    </script>
    <script>
        // Simple Process Navigation System
        let currentStep = 1;
        const totalSteps = 3;

        // Initialize when page loads
        document.addEventListener('DOMContentLoaded', function() {
            showStep(currentStep);
            updateProcessIndicator();
        });

        // Show specific step and hide others
        function showStep(stepNumber) {
            // Hide all sections
            for (let i = 1; i <= totalSteps; i++) {
                const section = document.querySelector(`.step-${i}`);
                if (section) {
                    section.style.display = 'none';
                }
            }

            // Show current step
            const currentSection = document.querySelector(`.step-${stepNumber}`);
            if (currentSection) {
                currentSection.style.display = 'block';
            }

            currentStep = stepNumber;
            updateProcessIndicator();
        }

        // Update process indicator steps
        function updateProcessIndicator() {
            const indicators = document.querySelectorAll('.process-step');

            indicators.forEach((indicator, index) => {
                const stepNumber = index + 1;
                indicator.classList.remove('active', 'completed');

                if (stepNumber < currentStep) {
                    indicator.classList.add('completed');
                } else if (stepNumber === currentStep) {
                    indicator.classList.add('active');
                    // If we're on step 3, make it completed (green background)
                    if (stepNumber === 3) {
                        indicator.classList.add('completed');
                        indicator.classList.remove('active');
                    }
                }
            });

            // Update step titles
            const stepTitles = document.querySelectorAll('.step-title');
            stepTitles.forEach((title, index) => {
                const stepNumber = index + 1;
                title.classList.remove('active');

                if (stepNumber === currentStep) {
                    title.classList.add('active');
                }
            });
        }

        // Next button click
        document.addEventListener('click', function(e) {
            if (e.target.classList.contains('btn-next')) {
                e.preventDefault();
                if (currentStep < totalSteps) {
                    showStep(currentStep + 1);
                }
            }
        });

        // Back button click
        document.addEventListener('click', function(e) {
            if (e.target.classList.contains('btn-back')) {
                e.preventDefault();
                if (currentStep > 1) {
                    showStep(currentStep - 1);
                }
            }
        });

        // Process step click (optional - click on step numbers to navigate)
        document.addEventListener('click', function(e) {
            if (e.target.classList.contains('process-step') || e.target.parentElement.classList.contains(
                    'process-step')) {
                const stepElement = e.target.classList.contains('process-step') ? e.target : e.target.parentElement;
                const stepNumber = parseInt(stepElement.getAttribute('data-step'));
                if (stepNumber && stepNumber >= 1 && stepNumber <= totalSteps) {
                    showStep(stepNumber);
                }
            }
        });
    </script>

    <script>
        $(".card-type-container").on("click", function() {
            let value = $(this).data("type");
            // console.log("Selected value:", value);
        });
    </script>

    <script>
        $(document).ready(function() {
            acceptVar();
            getExchangeRate();
            getFees();
            stepTwoValidation();
        });

        $('input[name="card_holder_name"]').on('input', function() {
            acceptVar();
            getFees();
            stepTwoValidation();
        });

        $("select[name=card_currency]").change(function() {
            acceptVar();
            getExchangeRate();
            getFees();
            stepTwoValidation();
        });
        $("select[name=wallet_currency]").change(function() {
            acceptVar();
            getExchangeRate();
            getFees();
            stepTwoValidation();
        });

        $(document).on('click', '.card-type-container', function() {
            acceptVar();
            getExchangeRate();
            getFees();
            stepOneValidation();
        });

        $(document).on('click', '.provider-option', function() {
            acceptVar();
            getExchangeRate();
            getFees();
            stepTwoValidation();
        });

        $(document).on('click', '.btn-issue', function() {
            submit()
        });

        function acceptVar() {
            var cardHolderName                  = $("input[name=card_holder_name]").val();
            var cardCurrency                    = $("select[name=card_currency] :selected");
            var cardCurrencyId                  = cardCurrency.val();
            var cardCurrencyCode                = cardCurrency.data('currency-code');
            var cardCurrencyRate                = cardCurrency.data('rate');
            var cardCurrencyMinLimit            = cardCurrency.data('min-limit');
            var cardCurrencyMaxLimit            = cardCurrency.data('max-limit');
            var cardCurrencyDailyLimit          = cardCurrency.data('daily-limit');
            var cardCurrencyMonthlyLimit        = cardCurrency.data('monthly-limit');
            var cardCurrencyUniversalPackageFee = cardCurrency.data('universal-package-fee');
            var cardCurrencyPlatinumPackageFee  = cardCurrency.data('platinum-package-fee');
            var cardCurrencyDepositFixedFee     = cardCurrency.data('card-deposit-fixed-fee');
            var cardCurrencyWithdrawFixedFee    = cardCurrency.data('card-withdraw-fixed-fee');
            var cardCurrencyMaintenanceFixedFee = cardCurrency.data('card-maintenance-fixed-fee');
            var cardCurrencySymbol              = cardCurrency.data('currency-symbol');

            var wallet               = $("select[name=wallet_currency] :selected");
            var walletId             = wallet.val();
            var walletRate           = wallet.data('rate');
            var walletCurrencyCode   = wallet.data('currency-code');
            var walletCurrencySymbol = wallet.data('currency-symbol');
            var cardType             = $('.card-type-container.selected').data('card-type');
            var cardProvider         = $('.provider-option.selected').data('provider');

            return {
                cardHolderName                 : cardHolderName,
                cardCurrency                   : cardCurrency,
                cardCurrencyId                 : cardCurrencyId,
                cardCurrencyCode               : cardCurrencyCode,
                cardCurrencyRate               : cardCurrencyRate,
                cardCurrencyMinLimit           : cardCurrencyMinLimit,
                cardCurrencyMaxLimit           : cardCurrencyMaxLimit,
                cardCurrencyDailyLimit         : cardCurrencyDailyLimit,
                cardCurrencyMonthlyLimit       : cardCurrencyMonthlyLimit,
                cardCurrencyUniversalPackageFee: cardCurrencyUniversalPackageFee,
                cardCurrencyPlatinumPackageFee : cardCurrencyPlatinumPackageFee,
                cardCurrencyDepositFixedFee    : cardCurrencyDepositFixedFee,
                cardCurrencyWithdrawFixedFee   : cardCurrencyWithdrawFixedFee,
                cardCurrencyMaintenanceFixedFee: cardCurrencyMaintenanceFixedFee,
                cardCurrencySymbol             : cardCurrencySymbol,
                cardProvider                   : cardProvider,

                wallet              : wallet,
                walletId            : walletId,
                walletRate          : walletRate,
                walletCurrencyCode  : walletCurrencyCode,
                walletCurrencySymbol: walletCurrencySymbol,

                cardType: cardType,

            };
        }

        function getExchangeRate() {
            var card_currency      = acceptVar().cardCurrencySymbol;
            var card_currency_rate = acceptVar().cardCurrencyRate;

            var wallet_currency      = acceptVar().walletCurrencySymbol;
            var wallet_currency_rate = acceptVar().walletRate;
            var rate                 = parseFloat(wallet_currency_rate) / parseFloat(card_currency_rate);

            if (wallet_currency == null || wallet_currency == "" || card_currency == null || card_currency == "") {
                return false;
            }

            $('.exchange-rate').html("1 " + card_currency + " = " + parseFloat(rate).toFixed(8) + " " + wallet_currency);

            return rate;
        }


        function feesCalculation() {
            var exchange_rate = getExchangeRate();
            if (acceptVar().cardType == 'universal') {
                var card_issue_charge = acceptVar().cardCurrencyUniversalPackageFee;
            } else if (acceptVar().cardType == 'platinum') {
                var card_issue_charge = acceptVar().cardCurrencyPlatinumPackageFee;
            }

            if ($.isNumeric(card_issue_charge)) {
                // Process Calculation
                var card_issue_calc      = parseFloat(card_issue_charge) * parseFloat(exchange_rate);
                var total_charge         = parseFloat(card_issue_calc);
                    total_charge         = parseFloat(total_charge).toFixed(8);
                var total_payable_amount = parseFloat(total_charge);
                // return total_charge;
                return {
                    issue        : parseFloat(card_issue_calc).toFixed(8),
                    total        : parseFloat(total_charge).toFixed(8),
                    total_payable: parseFloat(total_payable_amount).toFixed(8),
                };
            } else {
                // return "--";
                return false;
            }
        }

        function getFees() {
            var wallet_currency = acceptVar().walletCurrencySymbol;
            var card_currency   = acceptVar().cardCurrencySymbol;
            var charges         = feesCalculation();

            if (charges == false || wallet_currency == null || wallet_currency == "" || card_currency == null || card_currency == "") {
                return false;
            }

            $(".fees-show").html(parseFloat(charges.total).toFixed(8) + " " +
                wallet_currency);
            $(".issue-fee").html(parseFloat(charges.issue).toFixed(8) + " " +
                wallet_currency);
            $(".total-amount").html(parseFloat(charges.total_payable).toFixed(8) + " " +
                wallet_currency);
        }

        function stepOneValidation(){
            let cardType = acceptVar().cardType;
            if(cardType){
                $('.step-two').removeClass('disabled');
            }
        }

        function stepTwoValidation(){
            let isValid = true;
            let cardHolderName = acceptVar().cardHolderName;
            let provider       = acceptVar().cardProvider;
            let wallet         = acceptVar().walletId;
            let cardCurrency   = acceptVar().cardCurrencyId;

            if (!cardHolderName || cardHolderName == null || cardHolderName == "") {
                isValid = false;
            }

            if (!provider) {
                isValid = false;
            }

            if (!wallet) {
                isValid = false;
            }

            if (!cardCurrency) {
                isValid = false;
            }

            if (isValid) {
                $('.issue-card').removeClass('disabled');
            }
            else{
                $('.issue-card').addClass('disabled');
            }
        }

        function submit() {
            // Collect and validate input data
            let cardHolderName = acceptVar().cardHolderName.trim();
            let provider       = acceptVar().cardProvider;
            let cardType       = acceptVar().cardType;
            let cardCurrency   = acceptVar().cardCurrencyCode;
            let wallet         = acceptVar().walletCurrencyCode;

            // Prepare data for sending
            let data = {
                _token       : $('meta[name="csrf-token"]').attr('content'),   // Laravel CSRF token
                name_on_card : cardHolderName,
                card_tier    : cardType,
                card_type    : provider,
                currency     : cardCurrency,
                from_currency: wallet
            };

            // Send AJAX POST request
            $.ajax({
                url: "{{ route('user.cardyfie.virtual.card.create') }}", // 🔹 your Laravel route name
                method: "POST",
                data: data,
                beforeSend: function() {
                    // Optional: show loading spinner or disable button
                    $('.btn-issue').prop('disabled', true).text('Processing...');
                },
                success: function(response) {
                    console.log(response.message.success);
                    throwMessage('success',[response.message.success.success[0]]);
                    $('.step-two').addClass('completed')
                    $('.step-three').addClass('completed')
                    $('.step-2').css('display', 'none');
                    $('.step-3').css('display', 'block');
                },
                error: function(xhr) {
                    $('.btn-issue').prop('disabled', false).text('Issue Card');
                    console.log(xhr.responseJSON);
                    throwMessage('error',[xhr.responseJSON.message.error.error[0]]);
                },
                complete: function() {

                }
            });
        }


    </script>
@endpush
