<div class="dashboard-area mt-20">
    <div class="dashboard-container">
        <div class="row">
            <div class="col-lg-12">
                <div class="cc-section-header">
                    <div>
                        <div class="cc-section-title">{{ __('Card Statistics') }}</div>
                    </div>
                    <a href="{{ route('user.cardyfie.virtual.card.create') }}" class="cc-add-btn" @disabled($card_api->card_limit == $total_cards)>
                        <i class="fas fa-plus"></i> {{ __('Add New') }}
                    </a>
                </div>

                <div class="row">
                    <div class="col-xl-3 col-md-3 col-6">
                        <div class="cc-stat-card">
                            <div class="cc-stat-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="cc-stat-value">
                                {{ get_amount($total_amount_of_cards->total_amount,$total_amount_of_cards->currency,2) }}
                            </div>
                            <div class="cc-stat-label">{{ __('Total Card Balance') }}</div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-3 col-6 ">
                        <div class="cc-stat-card">
                            <div class="cc-stat-icon">
                                <i class="fas fa-credit-card"></i>
                            </div>
                            <div class="cc-stat-value">{{ $total_cards }}</div>
                            <div class="cc-stat-label">{{ __('Existing Cards') }}</div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-3 col-6 ">
                        <div class="cc-stat-card">
                            <div class="cc-stat-icon">
                                <i class="fas fa-snowflake"></i>
                            </div>
                            <div class="cc-stat-value">{{ $total_freezed_cards }}</div>
                            <div class="cc-stat-label">{{ __('Total Freezed') }}</div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-3 col-6 ">
                        <div class="cc-stat-card">
                            <div class="cc-stat-icon">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <div class="cc-stat-value">{{ $total_enabled_cards }}</div>
                            <div class="cc-stat-label">{{ __('Total Enabled') }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--Available cards section -->
        <div class="available-cards-section">
            <div class="row">
                <div class="col-xl-12">
                    <div class="cc-section-header">
                        <div>
                            <div class="cc-section-title">{{ __('Available Cards') }} {{ "(".$total_cards."/".$card_api->card_limit.")" }}</div>
                        </div>
                    </div>
                </div>
                <div class="saved-cards-container">
                    <div class="row justify-content-center">
                        @forelse ($customer_cards ?? [] as $card)
                            <div class="col-12 col-sm-6 col-md-4  col-xl-3 mb-4">
                                <div class="card-container card-details" data-card-id="{{ $card->ulid }}"  onclick="openModal()">
                                    <div class="card-bg"></div>
                                    <div class="gradient-overlay"></div>
                                    <div class="card-content">
                                        <div class="card-header">
                                            <img class="logo" src="{{ get_fav($basic_settings) ?? "" }}" alt="logo">
                                            <div class="status">
                                                @if ($card->status == "ENABLED")
                                                    <div class="status-dot bg-success"></div>
                                                    {{ __('Active') }}
                                                @elseif ($card->status == "CLOSED")
                                                    <div class="status-dot bg-danger"></div>
                                                    {{ __('Closed') }}
                                                @else
                                                    <div class="status-dot bg-warning"></div>
                                                    {{ __('Freeze') }}
                                                @endif
                                            </div>
                                        </div>
                                        <div class="card-number">{{ $card->masked_pan }}</div>
                                        <div class="card-holder text-capitalize">{{ $card->card_name }}</div>
                                        <div class="card-footer">
                                            <div class="balance">{{ get_amount($card->amount,$card->currency,'double') }}</div>
                                            <!-- Mastercard SVG -->

                                            @if ($card->card_type == "visa")
                                                <img class="card-brand" src="{{ get_image('frontend/images/card/visa_5968299.svg') }}"
                                                alt="">
                                            @else
                                                <img class="card-brand" src="{{ get_image('frontend/images/card/mastercard-svg.svg') }}"
                                                    alt="">
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="alert alert-primary text-center">
                                {{ __("No Card Created Yet!") }}
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
        <!--saved cards modal -->
        <div class="saved-cards-modal">
            <!-- Modal Overlay -->
            <div class="modal-overlay" id="modalOverlay">
                <!-- Card Info Modal -->
                <div id="card-info-modal">
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="modal-title-section">
                            <div class="modal-icon">💳</div>
                            <div class="modal-title-text">
                                <h3>{{ __('Card Information') }}</h3>
                                <p>{{ __('Move funds within your card, freeze or close it') }}</p>
                            </div>
                        </div>
                        <button class="close-btn" onclick="closeModal()">&times;</button>
                    </div>

                    <!-- Modal Content -->
                    <div class="modal-content d-flex ">
                        <div class="row">
                            <div class="col-12 col-sm-6 col-md-6">
                                <!-- Card Section -->
                                <div class="card-section">
                                    <div class="modal-card card-loading d-flex justify-content-center align-items-center" style="height: 250px">
                                        <div class="spinner-border text-white" role="status">
                                            <span class="sr-only">{{ __('Loading') }}...</span>
                                        </div>
                                    </div>
                                    <div class="modal-card card-show d-none">
                                        <div class="modal-card-header">
                                            <img class="logo" src="{{ get_fav($basic_settings) ?? "" }}"
                                                alt="">
                                            <div class="card-status">
                                                <div class="status-dot"></div>
                                                <span class="status-text text-white">{{ __('Enabled') }}</span>
                                            </div>
                                        </div>

                                        <div class="card-number-section">
                                            <span class="card-number" id="cardNumber"></span>
                                            <button class="copy-btn" onclick="copyCardNumber()"
                                                title="Copy card number">
                                                <i class="fas fa-copy"></i>
                                            </button>
                                        </div>

                                        <div class="cardholder-name text-capitalize" id="holderName"></div>

                                        <div class="card-info-row">
                                            <div class="info-group">
                                                <span class="info-label">{{ __('EXP') }}</span>
                                                <div class="info-value-container">
                                                    <span class="info-value" id="expiryDate"></span>
                                                    <button class="copy-btn" onclick="copyExpiry()"
                                                        title="Copy expiry">
                                                        <i class="fas fa-copy"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="info-group">
                                                <span class="info-label">{{ __('CVV') }}</span>
                                                <div class="info-value-container">
                                                    <span class="info-value" id="cvvNumber"></span>
                                                    <button class="copy-btn" onclick="copyCVV()" title="Copy CVV">
                                                        <i class="fas fa-copy"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="card-brand-container">
                                                <img class="card-brand" src="{{ get_image('frontend/images/card/mastercard-svg.svg') }}"
                                                    alt="VISA logo">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Account Info -->
                                <div class="account-info">
                                    <div class="info-item">
                                        <div class="info-item-label">{{ __('Balance') }}</div>
                                        <div class="info-item-value balance-value" id="cardBalance">{{ __('Loading...') }}</div>
                                    </div>
                                </div>
                            </div>



                            <div class="col-12 col-sm-6 col-md-6">
                                <!-- Billing Address -->
                                <div class="billing-section">
                                    <div class="billing-header">
                                        <h4 class="billing-title">{{ __('Billing Address') }}</h4>
                                    </div>
                                    <div class="billing-address">
                                        <div class="billing-adress-wrapper" id="billingAddress">
                                            <p>{{ __('Loading') }}</p>
                                        </div>
                                        <div class="billing-address-copy-icon">
                                            <button class="copy-btn" onclick="copyBillingAddress()"
                                                title="Copy billing address">
                                                <i class="fas fa-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <!-- Action Buttons -->
                                <div class="action-buttons" id="transaction-loading">

                                </div>

                                <div class="action-buttons" id="deposit-loading">

                                </div>

                                <!-- Bottom Actions -->
                                <div class="bottom-actions">
                                    <div class="withdraw-loading">

                                    </div>

                                        <button class="freeze-btn freeze-loading">
                                            {{ __('Loading') }}
                                        </button>
                                        <button class="freeze-btn freeze-workable d-none" id="freezeBtn">
                                            {{ __('Freeze') }}
                                        </button>

                                </div>

                                <!-- Close Card -->
                                <div class="close-card-section" id="close-loading">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Copy Notification -->
            <div class="copy-notification" id="copyNotification">
                {{ __('Copied to clipboard') }}!
            </div>
        </div>
    </div>
</div>
