<div class="col-xxl-10 col-xl-10 col-lg-10">
    <div class="custom-card">
        <div class="dashboard-header-wrapper">
            <h5 class="title">{{ __('Create Card Customer') }}</h5>
        </div>
        <div class="card-body">
            <form action="{{ setRoute('user.cardyfie.virtual.card.create.customer') }}" class="card-form" method="POST"
                enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('First Name') }}<span>*</span></label>
                        <div class="input-group max">
                            <input type="text" class="form--control" name="first_name"
                                placeholder="{{ __('Enter First Name') }}..."
                                value="{{ old('first_name', $user->firstname) }}">
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('Last Name') }}<span>*</span></label>
                        <div class="input-group max">
                            <input type="text" class="form--control" name="last_name"
                                placeholder="{{ __('Enter Last Name') }}..."
                                value="{{ old('last_name', $user->lastname) }}">
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('Email Name') }}<span>*</span></label>
                        <div class="input-group max">
                            <input type="email" class="form--control" name="email"
                                value="{{ old('customer_email', $user->email) }}"
                                placeholder="{{ __('Enter Email') }}...">
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('Date Of Birth') }}<span>*</span> <small>(
                                {{ __('Should match with tour ID') }} )</small></label>
                        <div class="input-group max">
                            <input type="date" class="form--control" name="date_of_birth"
                                value="{{ old('date_of_birth') }}">
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('Identity Type') }} <span class="text--base">*</span></label>
                        <select class="form--control" name="identity_type" required>
                            <option disabled selected value="null">{{ __('Choose One') }}</option>
                            <option value="nid">{{ __('National ID Card (NID)') }}</option>
                            <option value="passport">{{ __('Passport') }}</option>
                            <option value="bvn">{{ __('Bank Verification Number') }}</option>
                        </select>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('Identity Number') }} <span class="text--base">*</span></label>
                        <div class="input-group">
                            <input type="text" class="form--control" required
                                placeholder="{{ __('Enter Identity Number') }}" name="identity_number"
                                value="{{ old('identity_number') }}">
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('ID Card Image (Font Side)') }} <span class="text--base">*</span></label>
                        <div class="input-group">
                            <input type="file" class="form--control" required name="id_front_image">
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('ID Card Image (Back Side)') }} <span class="text--base">*</span></label>
                        <div class="input-group">
                            <input type="file" class="form--control" required name="id_back_image">
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('Your Photo') }} <span class="text--base">*</span></label>
                        <div class="input-group">
                            <input type="file" class="form--control" required name="user_image">
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('House Number') }} <span class="text--base">*</span></label>
                        <div class="input-group">
                            <input type="text" class="form--control" required name="house_number"
                                placeholder="{{ __('Enter House Number') }}" value="{{ old('house_number') }}">
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('Country') }} <span class="text--base">*</span></label>
                        <select class="form--control select2-basic" name="country" required>
                            <option disabled selected value="null">{{ __('Select Country') }}</option>
                            @foreach (get_all_countries() ?? [] as $country)
                                <option value="{{ $country->iso2 }}"
                                    {{ $user->address->country ?? '' == $country->name ? 'selected' : '' }}>
                                    {{ $country->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('City') }} <span class="text--base">*</span></label>
                        <div class="input-group">
                            <input type="text" class="form--control" required name="city"
                                placeholder="{{ __('Enter City') }}"
                                value="{{ old('city', $user->address->city ?? '') }}">
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('State') }} <span class="text--base">*</span></label>
                        <div class="input-group">
                            <input type="text" class="form--control" required name="state"
                                placeholder="{{ __('Enter State') }}"
                                value="{{ old('state', $user->address->state ?? '') }}">
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('Zip Code') }} <span class="text--base">*</span></label>
                        <div class="input-group">
                            <input type="text" class="form--control" required name="zip_code"
                                placeholder="{{ __('Enter Zip Code') }}"
                                value="{{ old('zip_code', $user->address->zip_code ?? '') }}">
                        </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <label>{{ __('Address') }} <span class="text--base">*</span></label>
                        <div class="input-group">
                            <textarea class="form--control" name="address" id="address" cols="30" rows="10" required>{{ old('address', $user->address->address ?? '') }}</textarea>
                        </div>
                    </div>
                </div>
                <div class="col-xl-12 col-lg-12">
                    <button type="submit" class="btn--base w-100"><span
                            class="w-100">{{ __('Continue') }}</span></button>
                </div>
            </form>
        </div>
    </div>
</div>
